/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.bigbang.box.generators;

import io.intino.alexandria.event.message.MessageEvent;
import io.intino.alexandria.message.Message;
import io.intino.cosmos.bigbang.box.BigBangBox;
import io.intino.cosmos.bigbang.box.generators.Formatters;
import java.util.Map;
import java.util.Objects;

public class AssertionFactory {
    private final String unit;
    private final String assertionClass;

    public static AssertionFactory of(String unit, String generalType) {
        return new AssertionFactory(unit, generalType);
    }

    protected AssertionFactory(String unit, String assertionClass) {
        this.unit = unit;
        this.assertionClass = Objects.requireNonNull(assertionClass);
    }

    public MessageEvent create(String id, Map<String, Object> attributes) {
        Message message = new Message(Formatters.capitalize(this.assertionClass));
        message.set("ss", this.ss()).set("ts", BigBangBox.BIG_BANG_TS).set("id", id);
        this.fill(attributes, message);
        return new MessageEvent(message);
    }

    protected void fill(Map<String, Object> record, Message message) {
        record.forEach((k, v) -> {
            if (k.equals("class") || v == null) {
                return;
            }
            if (v instanceof Map) {
                Map m = (Map)v;
                Message component = new Message(m.get("class").toString());
                this.fill(m, component);
                message.add(component);
            } else {
                message.set((String)k, v);
            }
        });
    }

    protected String ss() {
        return this.unit == null ? "big-bang" : this.unit + "?author=big-bang";
    }
}

