/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.bigbang.box.actions;

import io.intino.alexandria.Context;
import io.intino.alexandria.logger.Logger;
import io.intino.cosmos.bigbang.box.BigBangBox;
import io.intino.cosmos.bigbang.box.BigBangException;
import io.intino.cosmos.bigbang.box.actions.CheckAction;
import io.intino.cosmos.bigbang.box.generators.ChangeBroadcaster;
import io.intino.cosmos.bigbang.box.generators.UniverseAssertionGenerator;
import io.intino.cosmos.bigbang.box.report.IssueReport;

public class UpdateAction {
    public BigBangBox box;
    public Context context = new Context();
    public String unit;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() {
        Class<BigBangBox> clazz = BigBangBox.class;
        synchronized (BigBangBox.class) {
            try {
                IssueReport report = new CheckAction(this.box, this.unit).check();
                if (report.errorCount() > 0) {
                    this.fail(report);
                }
                Logger.info("Updating " + this.unit + "...");
                new UniverseAssertionGenerator(this.box, this.unit).execute();
                new ChangeBroadcaster().execute();
                Logger.info("Done");
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.unit + ": update complete";
            }
            catch (Throwable e) {
                Logger.error(e);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return e.getClass().getSimpleName() + ": " + e.getMessage();
            }
        }
    }

    private void fail(IssueReport report) {
        throw new BigBangException("Universe unit " + this.unit + " contains " + report.errorCount() + " errors. Cannot continue with the update.");
    }
}

