/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.bigbang.box.actions;

import io.intino.alexandria.logger.Logger;
import io.intino.cosmos.bigbang.box.BigBangBox;
import io.intino.cosmos.bigbang.box.BigBangConfiguration;
import io.intino.cosmos.bigbang.box.GitRepository;
import io.intino.cosmos.bigbang.box.actions.UpdateAction;
import java.net.URISyntaxException;
import org.eclipse.jgit.api.errors.GitAPIException;

public class PullAndPropagateChangesAction {
    public BigBangBox box;

    public void execute() {
        BigBangConfiguration conf = this.box.configuration();
        if (conf.gitRemote() == null) {
            return;
        }
        try {
            boolean alreadyExists = conf.universeDirectory().exists();
            GitRepository gitRepository = new GitRepository(conf.universeDirectory(), conf.gitRemote(), conf.gitBranch());
            if (!alreadyExists || gitRepository.checkoutAndPull() == GitRepository.PullResult.FAST_FORWARD) {
                this.updateUnit();
            }
        }
        catch (URISyntaxException | GitAPIException e) {
            Logger.error(e);
        }
    }

    private void updateUnit() {
        UpdateAction action = new UpdateAction();
        action.box = this.box;
        action.unit = this.box.configuration().unit();
        action.execute();
    }
}

