/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.bigbang.box.actions;

import io.intino.alexandria.Context;
import io.intino.alexandria.logger.Logger;
import io.intino.cosmos.bigbang.box.BigBangBox;
import io.intino.cosmos.bigbang.box.UniverseValidator;
import io.intino.cosmos.bigbang.box.report.IssueReport;
import java.io.File;

public class CheckAction {
    public BigBangBox box;
    public String unit;
    public Context context = new Context();

    public CheckAction() {
    }

    public CheckAction(BigBangBox box, String unit) {
        this.box = box;
        this.unit = unit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String execute() {
        Class<BigBangBox> clazz = BigBangBox.class;
        synchronized (BigBangBox.class) {
            try {
                IssueReport report = this.check();
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return this.unit + " check complete: " + report.errorCount() + " errors, " + report.warningCount() + " warnings";
            }
            catch (Throwable e) {
                Logger.error(e);
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return e.getClass().getSimpleName() + ": " + e.getMessage();
            }
        }
    }

    public IssueReport check() {
        Logger.info("Checking " + this.unit + "...");
        IssueReport report = UniverseValidator.validate(this.box.universeDir(), this.unit, this.box.terminal().metamodel());
        this.saveReport(report);
        return report;
    }

    private void saveReport(IssueReport report) {
        File txt = new File(this.box.logsDirectory(), this.unit + ".txt");
        File html = new File(this.box.logsDirectory(), this.unit + ".html");
        if (report.isEmpty()) {
            txt.delete();
            html.delete();
            return;
        }
        txt.getParentFile().mkdirs();
        report.saveTxt(txt);
        html.getParentFile().mkdirs();
        report.saveHtml(html);
    }
}

