/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.bigbang.box;

import io.intino.alexandria.logger.Logger;
import io.intino.cosmos.bigbang.box.generators.Formatters;
import io.intino.cosmos.bigbang.box.report.Issue;
import io.intino.cosmos.bigbang.box.report.IssueReport;
import io.intino.cosmos.datahub.BigBangTerminal;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.parser.ParserException;

public class UniverseValidator {
    private final File universeDir;
    private final String unit;
    private final Map<String, BigBangTerminal.MetaMessage> metamodel;
    private final IssueReport report;
    private final Yaml yaml;
    private File fileContext;

    public static IssueReport validate(File universeDir, String unit, List<BigBangTerminal.MetaMessage> metamodel) {
        return new UniverseValidator(universeDir, unit, metamodel).execute();
    }

    public UniverseValidator(File universeDir, String unit, List<BigBangTerminal.MetaMessage> metamodel) {
        this.universeDir = universeDir;
        this.unit = unit;
        this.metamodel = metamodel.stream().collect(Collectors.toMap(BigBangTerminal.MetaMessage::name, m -> m));
        this.report = new IssueReport();
        this.yaml = new Yaml();
        this.fileContext = null;
    }

    public IssueReport execute() {
        FileUtils.listFiles(this.universeDir, new String[]{"yaml"}, false).stream().filter(f -> !f.getName().startsWith("units.")).forEach(this::processFile);
        FileUtils.listFiles(new File(this.universeDir, this.unit + ".domain"), new String[]{"yaml"}, true).forEach(this::processFile);
        return this.report;
    }

    private void processFile(File f) {
        try {
            this.fileContext = f;
            Map objects = (Map)this.yaml.load(new FileReader(f));
            String proposedAssertionClass = Formatters.assertionClassOf(f);
            for (Map.Entry entry : objects.entrySet()) {
                if (!(entry.getValue() instanceof Map)) {
                    throw new IOException("Invalid entry format: " + (String)entry.getKey());
                }
                Map properties = (Map)entry.getValue();
                String definedAssertionClass = Formatters.capitalize(Formatters.lastPart(properties.getOrDefault("class", proposedAssertionClass).toString()) + "Assertion");
                this.validateProperties((String)entry.getKey(), properties, UniverseValidator.isProfile(f) ? this.profileDefinition() : this.metamodel.get(definedAssertionClass));
            }
        }
        catch (ParserException e) {
            this.report.put(Issue.error("Syntax error", "Syntax Error: " + e.getMessage()).source(f));
        }
        catch (IOException e) {
            Logger.error(e);
            this.report.put(Issue.error("Syntax error", "Syntax Error: " + e.getMessage()).source(f));
        }
    }

    private static boolean isProfile(File f) {
        return f.getParentFile().getName().equalsIgnoreCase("profiles");
    }

    private void validateProperties(String nodeName, Map<String, Object> properties, BigBangTerminal.MetaMessage definition) {
        if (definition == null) {
            this.report.put(Issue.error("Missing assertion", nodeName + " does not comply with any Assertion").source(this.fileContext));
        } else {
            if (!properties.containsKey("class")) {
                this.report.put(Issue.warning("Class attribute not found", "Entry " + nodeName + " without class: " + definition.name()).source(this.fileContext));
            }
            for (Map.Entry<String, Object> entry : properties.entrySet()) {
                Object object = entry.getValue();
                if (object instanceof Map) {
                    Map m = (Map)object;
                    String aClass = Formatters.lastPart(m.get("class").toString());
                    BigBangTerminal.MetaMessage componentDef = definition.components().stream().filter(c -> c.name().equalsIgnoreCase(aClass)).findFirst().orElse(null);
                    this.validateProperties(entry.getKey(), m, componentDef);
                    continue;
                }
                this.validateAttribute(entry, definition);
            }
        }
    }

    private BigBangTerminal.MetaMessage profileDefinition() {
        BigBangTerminal.MetaMessage profile = this.metamodel.get("ModelAssertion").components().stream().filter(c -> c.name().equalsIgnoreCase("Profile")).findFirst().orElse(null);
        return profile == null ? null : (BigBangTerminal.MetaMessage)profile.components().stream().filter(p -> p.name().equalsIgnoreCase("Variable")).findFirst().orElse(null);
    }

    private void validateAttribute(Map.Entry<String, Object> entry, BigBangTerminal.MetaMessage definition) {
        if (entry.getKey().equalsIgnoreCase("class")) {
            return;
        }
        BigBangTerminal.MetaAttribute metaAttribute = definition.attributes().stream().filter(a -> a.name().equalsIgnoreCase(Formatters.toCamel((String)entry.getKey()))).findFirst().orElse(null);
        if (metaAttribute == null) {
            this.report.put(Issue.warning("Invalid attribute", "Attribute " + entry.getKey() + "=" + String.valueOf(entry.getValue()) + " of " + definition.name() + " not found in definition").source(this.fileContext));
        } else {
            this.validateValue(entry.getValue(), metaAttribute);
        }
    }

    private void validateValue(Object value, BigBangTerminal.MetaAttribute def) {
        if (def.type().equalsIgnoreCase("Long")) {
            this.tryParseLong(value, def);
        } else if (def.type().equalsIgnoreCase("Boolean")) {
            this.tryParseBoolean(value, def);
        } else if (def.type().equalsIgnoreCase("Double")) {
            this.tryParseDouble(value, def);
        } else if (def.type().equalsIgnoreCase("Integer")) {
            this.tryParseInt(value, def);
        } else if (def.type().equalsIgnoreCase("Instant")) {
            this.tryParseInstant(value, def);
        } else if (def.type().equalsIgnoreCase("Enum")) {
            this.tryParseWord(value, def);
        }
    }

    private void tryParseLong(Object value, BigBangTerminal.MetaAttribute def) {
        try {
            if (value instanceof Long) {
                return;
            }
            Long.parseLong(value.toString());
        }
        catch (Exception e) {
            this.report.put(Issue.error("Invalid value", "Attribute " + def.name() + "=" + String.valueOf(value) + " cannot be parsed to " + def.type()).source(this.fileContext));
        }
    }

    private void tryParseBoolean(Object value, BigBangTerminal.MetaAttribute def) {
        try {
            if (value instanceof Boolean) {
                return;
            }
            Boolean.parseBoolean(value.toString());
        }
        catch (Exception e) {
            this.report.put(Issue.error("Invalid value", "Attribute " + def.name() + "=" + String.valueOf(value) + " cannot be parsed to " + def.type()).source(this.fileContext));
        }
    }

    private void tryParseDouble(Object value, BigBangTerminal.MetaAttribute def) {
        try {
            Double.parseDouble(value.toString());
        }
        catch (Exception e) {
            this.report.put(Issue.error("Invalid value", "Attribute " + def.name() + "=" + String.valueOf(value) + " cannot be parsed to " + def.type()).source(this.fileContext));
        }
    }

    private void tryParseInt(Object value, BigBangTerminal.MetaAttribute def) {
        try {
            Integer.parseInt(value.toString());
        }
        catch (Exception e) {
            this.report.put(Issue.error("Invalid value", "Attribute " + def.name() + "=" + String.valueOf(value) + " cannot be parsed to " + def.type()).source(this.fileContext));
        }
    }

    private void tryParseInstant(Object value, BigBangTerminal.MetaAttribute def) {
        try {
            Instant.parse(value.toString());
        }
        catch (Exception e) {
            this.report.put(Issue.error("Invalid value", "Attribute " + def.name() + "=" + String.valueOf(value) + " cannot be parsed to " + def.type()).source(this.fileContext));
        }
    }

    private void tryParseWord(Object value, BigBangTerminal.MetaAttribute def) {
    }
}

