/*
 * Decompiled with CFR 0.152.
 */
package io.intino.cosmos.archetype;

import io.intino.alexandria.Timetag;
import java.io.File;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class Archetype {
    private final File root;

    public Archetype(File root) {
        this.root = root;
        root.mkdirs();
    }

    public File root() {
        return this.root;
    }

    public Relative relative() {
        return new Relative(this.root);
    }

    private static File createParent(File file) {
        file.getParentFile().mkdirs();
        return file;
    }

    public Datavault datavault() {
        return new Datavault(this.root);
    }

    public Datalake datalake() {
        return new Datalake(this.root);
    }

    public Repository repository() {
        return new Repository(this.root);
    }

    public Datamarts datamarts() {
        return new Datamarts(this.root);
    }

    public Definitions definitions() {
        return new Definitions(this.root);
    }

    public Configuration configuration() {
        return new Configuration(this.root);
    }

    public Tmp tmp() {
        return new Tmp(this.root);
    }

    public Logs logs() {
        return new Logs(this.root);
    }

    public static class Relative {
        private final String name;
        private final File root;

        public Relative(File root) {
            this.name = "";
            this.root = root;
            root.mkdirs();
        }

        public String root() {
            return this.name;
        }

        public Datavault datavault() {
            return new Datavault(this.root, this.name);
        }

        public Datalake datalake() {
            return new Datalake(this.root, this.name);
        }

        public Repository repository() {
            return new Repository(this.root, this.name);
        }

        public Datamarts datamarts() {
            return new Datamarts(this.root, this.name);
        }

        public Definitions definitions() {
            return new Definitions(this.root, this.name);
        }

        public Configuration configuration() {
            return new Configuration(this.root, this.name);
        }

        public Tmp tmp() {
            return new Tmp(this.root, this.name);
        }

        public Logs logs() {
            return new Logs(this.root, this.name);
        }

        public static class Datavault {
            private final File root;
            private final String name;

            public Datavault(File parentRoot, String parent) {
                this.root = new File(parent, "datavault");
                this.root.mkdirs();
                this.name = parent + (!parent.isEmpty() ? "/" : "") + "datavault";
            }

            public String root() {
                return this.name;
            }

            public Logs logs() {
                return new Logs(this.root, this.name);
            }

            public static class Logs {
                private final File root;
                private final String name;

                public Logs(File parentRoot, String parent) {
                    this.root = new File(parent, "logs");
                    this.root.mkdirs();
                    this.name = parent + (!parent.isEmpty() ? "/" : "") + "logs";
                }

                public String root() {
                    return this.name;
                }

                public String of(String server, String app, String name) {
                    return "{server}/{app}/{name}".replace("{server}", server).replace("{app}", app).replace("{name}", name);
                }
            }
        }

        public static class Datalake {
            private final File root;
            private final String name;

            public Datalake(File parentRoot, String parent) {
                this.root = new File(parent, "datalake");
                this.root.mkdirs();
                this.name = parent + (!parent.isEmpty() ? "/" : "") + "datalake";
            }

            public String root() {
                return this.name;
            }
        }

        public static class Repository {
            private final File root;
            private final String name;

            public Repository(File parentRoot, String parent) {
                this.root = new File(parent, "documents");
                this.root.mkdirs();
                this.name = parent + (!parent.isEmpty() ? "/" : "") + "documents";
            }

            public String root() {
                return this.name;
            }

            public Employees employees() {
                return new Employees(this.root, this.name);
            }

            public Workorders workorders() {
                return new Workorders(this.root, this.name);
            }

            public Workreports workreports() {
                return new Workreports(this.root, this.name);
            }

            public Uploads uploads() {
                return new Uploads(this.root, this.name);
            }

            public static class Employees {
                private final File root;
                private final String name;

                public Employees(File parentRoot, String parent) {
                    this.root = new File(parent, "employees");
                    this.root.mkdirs();
                    this.name = parent + (!parent.isEmpty() ? "/" : "") + "employees";
                }

                public String root() {
                    return this.name;
                }

                public String getPhoto(String employee) {
                    return "{employee}".replace("{employee}", employee);
                }

                public String getSignature(String employee) {
                    return "signatures/{employee}.png".replace("{employee}", employee);
                }

                public String schedulePdf(String employee, String date) {
                    return "{employee}/schedules/pdf/{date}.pdf".replace("{employee}", employee).replace("{date}", date);
                }

                public String scheduleJson(String employee, String date) {
                    return "{employee}/schedules/json/{date}.json".replace("{employee}", employee).replace("{date}", date);
                }
            }

            public static class Workorders {
                private final File root;
                private final String name;

                public Workorders(File parentRoot, String parent) {
                    this.root = new File(parent, "workorders");
                    this.root.mkdirs();
                    this.name = parent + (!parent.isEmpty() ? "/" : "") + "workorders";
                }

                public String root() {
                    return this.name;
                }

                public String getStoreDirectory(String id) {
                    return "{id}".replace("{id}", id);
                }
            }

            public static class Workreports {
                private final File root;
                private final String name;

                public Workreports(File parentRoot, String parent) {
                    this.root = new File(parent, "workreports");
                    this.root.mkdirs();
                    this.name = parent + (!parent.isEmpty() ? "/" : "") + "workreports";
                }

                public String root() {
                    return this.name;
                }

                public List<String> workReports(Timetag date) {
                    if (!new File(this.root, "{date}").exists()) {
                        return Collections.emptyList();
                    }
                    return Arrays.stream(new File(this.root, "{date}").listFiles()).filter(f -> f.getName().contains(".pdf".replace("{date}", date.toString()))).map(f -> f.getName()).collect(Collectors.toList());
                }

                public String workReport(Timetag date, String employee, String instant) {
                    return "{date}/{employee}.{instant}.pdf".replace("{date}", date.toString()).replace("{employee}", employee).replace("{instant}", instant);
                }
            }

            public static class Uploads {
                private final File root;
                private final String name;

                public Uploads(File parentRoot, String parent) {
                    this.root = new File(parent, "uploads");
                    this.root.mkdirs();
                    this.name = parent + (!parent.isEmpty() ? "/" : "") + "uploads";
                }

                public String root() {
                    return this.name;
                }

                public String getUploadZipFile(String id) {
                    return "{id}.zip".replace("{id}", id);
                }
            }
        }

        public static class Datamarts {
            private final File root;
            private final String name;

            public Datamarts(File parentRoot, String parent) {
                this.root = new File(parent, "datamarts");
                this.root.mkdirs();
                this.name = parent + (!parent.isEmpty() ? "/" : "") + "datamarts";
            }

            public String root() {
                return this.name;
            }

            public String identities() {
                return "identities.zif";
            }

            public Indicators indicators() {
                return new Indicators(this.root, this.name);
            }

            public Ledgers ledgers() {
                return new Ledgers(this.root, this.name);
            }

            public Dashboards dashboards() {
                return new Dashboards(this.root, this.name);
            }

            public List<String> getDashboardDefinitions() {
                if (!new File(this.root, "/dashboards").exists()) {
                    return Collections.emptyList();
                }
                return Arrays.stream(new File(this.root, "/dashboards").listFiles()).filter(f -> f.getName().contains(".dashboard")).map(f -> f.getName()).collect(Collectors.toList());
            }

            public Sumus sumus() {
                return new Sumus(this.root, this.name);
            }

            public Wizard wizard() {
                return new Wizard(this.root, this.name);
            }

            public Trooper trooper() {
                return new Trooper(this.root, this.name);
            }

            public static class Indicators {
                private final File root;
                private final String name;

                public Indicators(File parentRoot, String parent) {
                    this.root = new File(parent, "indicators");
                    this.root.mkdirs();
                    this.name = parent + (!parent.isEmpty() ? "/" : "") + "indicators";
                }

                public String root() {
                    return this.name;
                }

                public String indicator(String source, String hoursAggregation) {
                    return "{source}/{hoursAggregation}.indicator".replace("{source}", source).replace("{hoursAggregation}", hoursAggregation);
                }

                public String indicator(String source) {
                    return "{source}.tl".replace("{source}", source);
                }

                public String indicatorDrill(String source, String drill, String group, String hoursAggregation) {
                    return "{source}/{drill}/{group}/{hoursAggregation}.indicator".replace("{source}", source).replace("{drill}", drill).replace("{group}", group).replace("{hoursAggregation}", hoursAggregation);
                }

                public String indicators(String source, String drill) {
                    return "{source}/{drill}".replace("{source}", source).replace("{drill}", drill);
                }
            }

            public static class Ledgers {
                private final File root;
                private final String name;

                public Ledgers(File parentRoot, String parent) {
                    this.root = new File(parent, "ledgers");
                    this.root.mkdirs();
                    this.name = parent + (!parent.isEmpty() ? "/" : "") + "ledgers";
                }

                public String root() {
                    return this.name;
                }

                public String getDefinition(String type) {
                    return "{type}.ledger".replace("{type}", type);
                }

                public List<String> getTsvs(String type) {
                    if (!new File(this.root, "{type}").exists()) {
                        return Collections.emptyList();
                    }
                    return Arrays.stream(new File(this.root, "{type}").listFiles()).filter(f -> f.getName().contains(".tsv".replace("{type}", type))).map(f -> f.getName()).collect(Collectors.toList());
                }

                public String getTsv(String type, Timetag period) {
                    return "{type}/{period}.tsv".replace("{type}", type).replace("{period}", period.toString());
                }
            }

            public static class Dashboards {
                private final File root;
                private final String name;

                public Dashboards(File parentRoot, String parent) {
                    this.root = new File(parent, "dashboards");
                    this.root.mkdirs();
                    this.name = parent + (!parent.isEmpty() ? "/" : "") + "dashboards";
                }

                public String root() {
                    return this.name;
                }

                public String getDefinition(String type) {
                    return "{type}.dashboard".replace("{type}", type);
                }
            }

            public static class Sumus {
                private final File root;
                private final String name;

                public Sumus(File parentRoot, String parent) {
                    this.root = new File(parent, "sumus");
                    this.root.mkdirs();
                    this.name = parent + (!parent.isEmpty() ? "/" : "") + "sumus";
                }

                public String root() {
                    return this.name;
                }

                public String calendar() {
                    return "calendar.tsv";
                }
            }

            public static class Wizard {
                private final File root;
                private final String name;

                public Wizard(File parentRoot, String parent) {
                    this.root = new File(parent, "wizard");
                    this.root.mkdirs();
                    this.name = parent + (!parent.isEmpty() ? "/" : "") + "wizard";
                }

                public String root() {
                    return this.name;
                }

                public String connections() {
                    return "connections.tsv";
                }

                public String incidents() {
                    return "incidents.tsv";
                }
            }

            public static class Trooper {
                private final File root;
                private final String name;

                public Trooper(File parentRoot, String parent) {
                    this.root = new File(parent, "trooper");
                    this.root.mkdirs();
                    this.name = parent + (!parent.isEmpty() ? "/" : "") + "trooper";
                }

                public String root() {
                    return this.name;
                }

                public Graph graph() {
                    return new Graph(this.root, this.name);
                }

                public Rollouts rollouts() {
                    return new Rollouts(this.root, this.name);
                }

                public String getLoggedInUsers() {
                    return "login.tsv";
                }

                public String getNotifications(String userEmail) {
                    return "notifications/{userEmail}.json".replace("{userEmail}", userEmail);
                }

                public String getObservablesStatus() {
                    return "observables-status.db";
                }

                public static class Graph {
                    private final File root;
                    private final String name;

                    public Graph(File parentRoot, String parent) {
                        this.root = new File(parent, "graph");
                        this.root.mkdirs();
                        this.name = parent + (!parent.isEmpty() ? "/" : "") + "graph";
                    }

                    public String root() {
                        return this.name;
                    }

                    public List<String> getActuations() {
                        if (!new File(this.root, "actuations").exists()) {
                            return Collections.emptyList();
                        }
                        return Arrays.stream(new File(this.root, "actuations").listFiles()).filter(f -> f.getName().contains(".stash")).map(f -> f.getName()).collect(Collectors.toList());
                    }

                    public String getActuations(Timetag period) {
                        return "actuations/{period}.stash".replace("{period}", period.toString());
                    }

                    public Rollouts rollouts() {
                        return new Rollouts(this.root, this.name);
                    }

                    public static class Rollouts {
                        private final File root;
                        private final String name;

                        public Rollouts(File parentRoot, String parent) {
                            this.root = new File(parent, "rollouts");
                            this.root.mkdirs();
                            this.name = parent + (!parent.isEmpty() ? "/" : "") + "rollouts";
                        }

                        public String root() {
                            return this.name;
                        }

                        public String getRollout(String name) {
                            return "{name}.stash".replace("{name}", name);
                        }
                    }
                }

                public static class Rollouts {
                    private final File root;
                    private final String name;

                    public Rollouts(File parentRoot, String parent) {
                        this.root = new File(parent, "rollouts");
                        this.root.mkdirs();
                        this.name = parent + (!parent.isEmpty() ? "/" : "") + "rollouts";
                    }

                    public String root() {
                        return this.name;
                    }

                    public Catalog catalog() {
                        return new Catalog(this.root, this.name);
                    }

                    public Sets sets() {
                        return new Sets(this.root, this.name);
                    }

                    public static class Catalog {
                        private final File root;
                        private final String name;

                        public Catalog(File parentRoot, String parent) {
                            this.root = new File(parent, "catalog");
                            this.root.mkdirs();
                            this.name = parent + (!parent.isEmpty() ? "/" : "") + "catalog";
                        }

                        public String root() {
                            return this.name;
                        }

                        public String getResults(String rollout) {
                            return "{rollout}.tsv".replace("{rollout}", rollout);
                        }
                    }

                    public static class Sets {
                        private final File root;
                        private final String name;

                        public Sets(File parentRoot, String parent) {
                            this.root = new File(parent, "sets");
                            this.root.mkdirs();
                            this.name = parent + (!parent.isEmpty() ? "/" : "") + "sets";
                        }

                        public String root() {
                            return this.name;
                        }

                        public String getSets(String target) {
                            return "{target}".replace("{target}", target);
                        }

                        public String getSetFile(String target, String setType, String value) {
                            return "{target}/{setType}/{value}.txt".replace("{target}", target).replace("{setType}", setType).replace("{value}", value);
                        }

                        public List<String> getSetOptions(String target, String setType) {
                            if (!new File(this.root, "{target}/{setType}").exists()) {
                                return Collections.emptyList();
                            }
                            return Arrays.stream(new File(this.root, "{target}/{setType}").listFiles()).filter(f -> f.getName().contains(".txt".replace("{target}", target).replace("{setType}", setType))).map(f -> f.getName()).collect(Collectors.toList());
                        }
                    }
                }
            }
        }

        public static class Definitions {
            private final File root;
            private final String name;

            public Definitions(File parentRoot, String parent) {
                this.root = new File(parent, "definitions");
                this.root.mkdirs();
                this.name = parent + (!parent.isEmpty() ? "/" : "") + "definitions";
            }

            public String root() {
                return this.name;
            }

            public String getOrderTypes() {
                return "order-types.triples";
            }

            public OrderTypes orderTypes() {
                return new OrderTypes(this.root, this.name);
            }

            public Agenda agenda() {
                return new Agenda(this.root, this.name);
            }

            public static class OrderTypes {
                private final File root;
                private final String name;

                public OrderTypes(File parentRoot, String parent) {
                    this.root = new File(parent, "order-types");
                    this.root.mkdirs();
                    this.name = parent + (!parent.isEmpty() ? "/" : "") + "order-types";
                }

                public String root() {
                    return this.name;
                }

                public String languageWorkReport(String category, String language) {
                    return "templates.{language}/{category}.docx".replace("{category}", category).replace("{language}", language);
                }

                public String areaWorkReport(String category, String area) {
                    return "templates.{area}/{category}.docx".replace("{category}", category).replace("{area}", area);
                }

                public String defaultWorkReport(String category) {
                    return "templates/{category}.docx".replace("{category}", category);
                }

                public String workReportCalculation(String category) {
                    return "templates/{category}.xlsx".replace("{category}", category);
                }

                public String attachmentsDirectory() {
                    return "attachments";
                }

                public String thesaurusDirectory() {
                    return "thesaurus";
                }
            }

            public static class Agenda {
                private final File root;
                private final String name;

                public Agenda(File parentRoot, String parent) {
                    this.root = new File(parent, "agenda");
                    this.root.mkdirs();
                    this.name = parent + (!parent.isEmpty() ? "/" : "") + "agenda";
                }

                public String root() {
                    return this.name;
                }

                public String weeklySchedule(String language) {
                    return "weekly-schedule.{language}.docx".replace("{language}", language);
                }
            }
        }

        public static class Configuration {
            private final File root;
            private final String name;

            public Configuration(File parentRoot, String parent) {
                this.root = new File(parent, "configuration");
                this.root.mkdirs();
                this.name = parent + (!parent.isEmpty() ? "/" : "") + "configuration";
            }

            public String root() {
                return this.name;
            }

            public String tags() {
                return "tags.tsv";
            }

            public String magnitudeDefinitions() {
                return "magnitude-definitions.tsv";
            }

            public String getTemplate(String name) {
                return "templates/{name}".replace("{name}", name);
            }

            public Trooper trooper() {
                return new Trooper(this.root, this.name);
            }

            public static class Trooper {
                private final File root;
                private final String name;

                public Trooper(File parentRoot, String parent) {
                    this.root = new File(parent, "trooper");
                    this.root.mkdirs();
                    this.name = parent + (!parent.isEmpty() ? "/" : "") + "trooper";
                }

                public String root() {
                    return this.name;
                }

                public Templates templates() {
                    return new Templates(this.root, this.name);
                }

                public String getTemplate(String name) {
                    return "templates/{name}".replace("{name}", name);
                }

                public Pages pages() {
                    return new Pages(this.root, this.name);
                }

                public String episodeSequencer() {
                    return "episodes.seq";
                }

                public String entityEditableAttributes() {
                    return "entity-editable-attributes.tsv";
                }

                public String translations() {
                    return "translations.triplets";
                }

                public String rolloutSequence() {
                    return "rollout.seq";
                }

                public String inventoryDefinition() {
                    return "inventory.json";
                }

                public String inventoryDefinitionImage(String name) {
                    return "inventory/{name}".replace("{name}", name);
                }

                public static class Templates {
                    private final File root;
                    private final String name;

                    public Templates(File parentRoot, String parent) {
                        this.root = new File(parent, "templates");
                        this.root.mkdirs();
                        this.name = parent + (!parent.isEmpty() ? "/" : "") + "templates";
                    }

                    public String root() {
                        return this.name;
                    }
                }

                public static class Pages {
                    private final File root;
                    private final String name;

                    public Pages(File parentRoot, String parent) {
                        this.root = new File(parent, "pages");
                        this.root.mkdirs();
                        this.name = parent + (!parent.isEmpty() ? "/" : "") + "pages";
                    }

                    public String root() {
                        return this.name;
                    }

                    public String index() {
                        return "index.html";
                    }

                    public String privacy() {
                        return "privacy.html";
                    }

                    public String tos() {
                        return "tos.html";
                    }
                }
            }
        }

        public static class Tmp {
            private final File root;
            private final String name;

            public Tmp(File parentRoot, String parent) {
                this.root = new File(parent, "tmp");
                this.root.mkdirs();
                this.name = parent + (!parent.isEmpty() ? "/" : "") + "tmp";
            }

            public String root() {
                return this.name;
            }
        }

        public static class Logs {
            private final File root;
            private final String name;

            public Logs(File parentRoot, String parent) {
                this.root = new File(parent, "logs");
                this.root.mkdirs();
                this.name = parent + (!parent.isEmpty() ? "/" : "") + "logs";
            }

            public String root() {
                return this.name;
            }

            public Trooper trooper() {
                return new Trooper(this.root, this.name);
            }

            public static class Trooper {
                private final File root;
                private final String name;

                public Trooper(File parentRoot, String parent) {
                    this.root = new File(parent, "trooper");
                    this.root.mkdirs();
                    this.name = parent + (!parent.isEmpty() ? "/" : "") + "trooper";
                }

                public String root() {
                    return this.name;
                }

                public String errors() {
                    return "errors.txt";
                }
            }
        }
    }

    public static class Datavault {
        private final File root;

        public Datavault(File parent) {
            this.root = new File(parent, "datavault");
            this.root.mkdirs();
        }

        public File root() {
            return this.root;
        }

        public Logs logs() {
            return new Logs(this.root);
        }

        public static class Logs {
            private final File root;

            public Logs(File parent) {
                this.root = new File(parent, "logs");
                this.root.mkdirs();
            }

            public File root() {
                return this.root;
            }

            public File of(String server, String app, String name) {
                return Archetype.createParent(new File(this.root, "{server}/{app}/{name}".replace("{server}", server).replace("{app}", app).replace("{name}", name)));
            }
        }
    }

    public static class Datalake {
        private final File root;

        public Datalake(File parent) {
            this.root = new File(parent, "datalake");
            this.root.mkdirs();
        }

        public File root() {
            return this.root;
        }
    }

    public static class Repository {
        private final File root;

        public Repository(File parent) {
            this.root = new File(parent, "documents");
            this.root.mkdirs();
        }

        public File root() {
            return this.root;
        }

        public Employees employees() {
            return new Employees(this.root);
        }

        public Workorders workorders() {
            return new Workorders(this.root);
        }

        public Workreports workreports() {
            return new Workreports(this.root);
        }

        public Uploads uploads() {
            return new Uploads(this.root);
        }

        public static class Employees {
            private final File root;

            public Employees(File parent) {
                this.root = new File(parent, "employees");
                this.root.mkdirs();
            }

            public File root() {
                return this.root;
            }

            public File getPhoto(String employee) {
                return Archetype.createParent(new File(this.root, "{employee}".replace("{employee}", employee)));
            }

            public File getSignature(String employee) {
                return Archetype.createParent(new File(this.root, "signatures/{employee}.png".replace("{employee}", employee)));
            }

            public File schedulePdf(String employee, String date) {
                return Archetype.createParent(new File(this.root, "{employee}/schedules/pdf/{date}.pdf".replace("{employee}", employee).replace("{date}", date)));
            }

            public File scheduleJson(String employee, String date) {
                return Archetype.createParent(new File(this.root, "{employee}/schedules/json/{date}.json".replace("{employee}", employee).replace("{date}", date)));
            }
        }

        public static class Workorders {
            private final File root;

            public Workorders(File parent) {
                this.root = new File(parent, "workorders");
                this.root.mkdirs();
            }

            public File root() {
                return this.root;
            }

            public File getStoreDirectory(String id) {
                return Archetype.createParent(new File(this.root, "{id}".replace("{id}", id)));
            }
        }

        public static class Workreports {
            private final File root;

            public Workreports(File parent) {
                this.root = new File(parent, "workreports");
                this.root.mkdirs();
            }

            public File root() {
                return this.root;
            }

            public List<File> workReports(Timetag date) {
                new File(this.root, "{date}".replace("{date}", date.toString())).mkdirs();
                return Arrays.stream(new File(this.root, "{date}".replace("{date}", date.toString())).listFiles()).filter(f -> f.getName().contains(".pdf")).collect(Collectors.toList());
            }

            public File workReport(Timetag date, String employee, String instant) {
                return Archetype.createParent(new File(this.root, "{date}/{employee}.{instant}.pdf".replace("{date}", date.toString()).replace("{employee}", employee).replace("{instant}", instant)));
            }
        }

        public static class Uploads {
            private final File root;

            public Uploads(File parent) {
                this.root = new File(parent, "uploads");
                this.root.mkdirs();
            }

            public File root() {
                return this.root;
            }

            public File getUploadZipFile(String id) {
                return Archetype.createParent(new File(this.root, "{id}.zip".replace("{id}", id)));
            }
        }
    }

    public static class Datamarts {
        private final File root;

        public Datamarts(File parent) {
            this.root = new File(parent, "datamarts");
            this.root.mkdirs();
        }

        public File root() {
            return this.root;
        }

        public File identities() {
            return Archetype.createParent(new File(this.root, "identities.zif"));
        }

        public Indicators indicators() {
            return new Indicators(this.root);
        }

        public Ledgers ledgers() {
            return new Ledgers(this.root);
        }

        public Dashboards dashboards() {
            return new Dashboards(this.root);
        }

        public List<File> getDashboardDefinitions() {
            new File(this.root, "/dashboards").mkdirs();
            return Arrays.stream(new File(this.root, "/dashboards").listFiles()).filter(f -> f.getName().contains(".dashboard")).collect(Collectors.toList());
        }

        public Sumus sumus() {
            return new Sumus(this.root);
        }

        public Wizard wizard() {
            return new Wizard(this.root);
        }

        public Trooper trooper() {
            return new Trooper(this.root);
        }

        public static class Indicators {
            private final File root;

            public Indicators(File parent) {
                this.root = new File(parent, "indicators");
                this.root.mkdirs();
            }

            public File root() {
                return this.root;
            }

            public File indicator(String source, String hoursAggregation) {
                return Archetype.createParent(new File(this.root, "{source}/{hoursAggregation}.indicator".replace("{source}", source).replace("{hoursAggregation}", hoursAggregation)));
            }

            public File indicator(String source) {
                return Archetype.createParent(new File(this.root, "{source}.tl".replace("{source}", source)));
            }

            public File indicatorDrill(String source, String drill, String group, String hoursAggregation) {
                return Archetype.createParent(new File(this.root, "{source}/{drill}/{group}/{hoursAggregation}.indicator".replace("{source}", source).replace("{drill}", drill).replace("{group}", group).replace("{hoursAggregation}", hoursAggregation)));
            }

            public File indicators(String source, String drill) {
                return Archetype.createParent(new File(this.root, "{source}/{drill}".replace("{source}", source).replace("{drill}", drill)));
            }
        }

        public static class Ledgers {
            private final File root;

            public Ledgers(File parent) {
                this.root = new File(parent, "ledgers");
                this.root.mkdirs();
            }

            public File root() {
                return this.root;
            }

            public File getDefinition(String type) {
                return Archetype.createParent(new File(this.root, "{type}.ledger".replace("{type}", type)));
            }

            public List<File> getTsvs(String type) {
                new File(this.root, "{type}".replace("{type}", type)).mkdirs();
                return Arrays.stream(new File(this.root, "{type}".replace("{type}", type)).listFiles()).filter(f -> f.getName().contains(".tsv")).collect(Collectors.toList());
            }

            public File getTsv(String type, Timetag period) {
                return Archetype.createParent(new File(this.root, "{type}/{period}.tsv".replace("{type}", type).replace("{period}", period.toString())));
            }
        }

        public static class Dashboards {
            private final File root;

            public Dashboards(File parent) {
                this.root = new File(parent, "dashboards");
                this.root.mkdirs();
            }

            public File root() {
                return this.root;
            }

            public File getDefinition(String type) {
                return Archetype.createParent(new File(this.root, "{type}.dashboard".replace("{type}", type)));
            }
        }

        public static class Sumus {
            private final File root;

            public Sumus(File parent) {
                this.root = new File(parent, "sumus");
                this.root.mkdirs();
            }

            public File root() {
                return this.root;
            }

            public File calendar() {
                return Archetype.createParent(new File(this.root, "calendar.tsv"));
            }
        }

        public static class Wizard {
            private final File root;

            public Wizard(File parent) {
                this.root = new File(parent, "wizard");
                this.root.mkdirs();
            }

            public File root() {
                return this.root;
            }

            public File connections() {
                return Archetype.createParent(new File(this.root, "connections.tsv"));
            }

            public File incidents() {
                return Archetype.createParent(new File(this.root, "incidents.tsv"));
            }
        }

        public static class Trooper {
            private final File root;

            public Trooper(File parent) {
                this.root = new File(parent, "trooper");
                this.root.mkdirs();
            }

            public File root() {
                return this.root;
            }

            public Graph graph() {
                return new Graph(this.root);
            }

            public Rollouts rollouts() {
                return new Rollouts(this.root);
            }

            public File getLoggedInUsers() {
                return Archetype.createParent(new File(this.root, "login.tsv"));
            }

            public File getNotifications(String userEmail) {
                return Archetype.createParent(new File(this.root, "notifications/{userEmail}.json".replace("{userEmail}", userEmail)));
            }

            public File getObservablesStatus() {
                return Archetype.createParent(new File(this.root, "observables-status.db"));
            }

            public static class Graph {
                private final File root;

                public Graph(File parent) {
                    this.root = new File(parent, "graph");
                    this.root.mkdirs();
                }

                public File root() {
                    return this.root;
                }

                public List<File> getActuations() {
                    new File(this.root, "actuations").mkdirs();
                    return Arrays.stream(new File(this.root, "actuations").listFiles()).filter(f -> f.getName().contains(".stash")).collect(Collectors.toList());
                }

                public File getActuations(Timetag period) {
                    return Archetype.createParent(new File(this.root, "actuations/{period}.stash".replace("{period}", period.toString())));
                }

                public Rollouts rollouts() {
                    return new Rollouts(this.root);
                }

                public static class Rollouts {
                    private final File root;

                    public Rollouts(File parent) {
                        this.root = new File(parent, "rollouts");
                        this.root.mkdirs();
                    }

                    public File root() {
                        return this.root;
                    }

                    public File getRollout(String name) {
                        return Archetype.createParent(new File(this.root, "{name}.stash".replace("{name}", name)));
                    }
                }
            }

            public static class Rollouts {
                private final File root;

                public Rollouts(File parent) {
                    this.root = new File(parent, "rollouts");
                    this.root.mkdirs();
                }

                public File root() {
                    return this.root;
                }

                public Catalog catalog() {
                    return new Catalog(this.root);
                }

                public Sets sets() {
                    return new Sets(this.root);
                }

                public static class Catalog {
                    private final File root;

                    public Catalog(File parent) {
                        this.root = new File(parent, "catalog");
                        this.root.mkdirs();
                    }

                    public File root() {
                        return this.root;
                    }

                    public File getResults(String rollout) {
                        return Archetype.createParent(new File(this.root, "{rollout}.tsv".replace("{rollout}", rollout)));
                    }
                }

                public static class Sets {
                    private final File root;

                    public Sets(File parent) {
                        this.root = new File(parent, "sets");
                        this.root.mkdirs();
                    }

                    public File root() {
                        return this.root;
                    }

                    public File getSets(String target) {
                        return Archetype.createParent(new File(this.root, "{target}".replace("{target}", target)));
                    }

                    public File getSetFile(String target, String setType, String value) {
                        return Archetype.createParent(new File(this.root, "{target}/{setType}/{value}.txt".replace("{target}", target).replace("{setType}", setType).replace("{value}", value)));
                    }

                    public List<File> getSetOptions(String target, String setType) {
                        new File(this.root, "{target}/{setType}".replace("{target}", target).replace("{setType}", setType)).mkdirs();
                        return Arrays.stream(new File(this.root, "{target}/{setType}".replace("{target}", target).replace("{setType}", setType)).listFiles()).filter(f -> f.getName().contains(".txt")).collect(Collectors.toList());
                    }
                }
            }
        }
    }

    public static class Definitions {
        private final File root;

        public Definitions(File parent) {
            this.root = new File(parent, "definitions");
            this.root.mkdirs();
        }

        public File root() {
            return this.root;
        }

        public File getOrderTypes() {
            return Archetype.createParent(new File(this.root, "order-types.triples"));
        }

        public OrderTypes orderTypes() {
            return new OrderTypes(this.root);
        }

        public Agenda agenda() {
            return new Agenda(this.root);
        }

        public static class OrderTypes {
            private final File root;

            public OrderTypes(File parent) {
                this.root = new File(parent, "order-types");
                this.root.mkdirs();
            }

            public File root() {
                return this.root;
            }

            public File languageWorkReport(String category, String language) {
                return Archetype.createParent(new File(this.root, "templates.{language}/{category}.docx".replace("{category}", category).replace("{language}", language)));
            }

            public File areaWorkReport(String category, String area) {
                return Archetype.createParent(new File(this.root, "templates.{area}/{category}.docx".replace("{category}", category).replace("{area}", area)));
            }

            public File defaultWorkReport(String category) {
                return Archetype.createParent(new File(this.root, "templates/{category}.docx".replace("{category}", category)));
            }

            public File workReportCalculation(String category) {
                return Archetype.createParent(new File(this.root, "templates/{category}.xlsx".replace("{category}", category)));
            }

            public File attachmentsDirectory() {
                return Archetype.createParent(new File(this.root, "attachments"));
            }

            public File thesaurusDirectory() {
                return Archetype.createParent(new File(this.root, "thesaurus"));
            }
        }

        public static class Agenda {
            private final File root;

            public Agenda(File parent) {
                this.root = new File(parent, "agenda");
                this.root.mkdirs();
            }

            public File root() {
                return this.root;
            }

            public File weeklySchedule(String language) {
                return Archetype.createParent(new File(this.root, "weekly-schedule.{language}.docx".replace("{language}", language)));
            }
        }
    }

    public static class Configuration {
        private final File root;

        public Configuration(File parent) {
            this.root = new File(parent, "configuration");
            this.root.mkdirs();
        }

        public File root() {
            return this.root;
        }

        public File tags() {
            return Archetype.createParent(new File(this.root, "tags.tsv"));
        }

        public File magnitudeDefinitions() {
            return Archetype.createParent(new File(this.root, "magnitude-definitions.tsv"));
        }

        public File getTemplate(String name) {
            return Archetype.createParent(new File(this.root, "templates/{name}".replace("{name}", name)));
        }

        public Trooper trooper() {
            return new Trooper(this.root);
        }

        public static class Trooper {
            private final File root;

            public Trooper(File parent) {
                this.root = new File(parent, "trooper");
                this.root.mkdirs();
            }

            public File root() {
                return this.root;
            }

            public Templates templates() {
                return new Templates(this.root);
            }

            public File getTemplate(String name) {
                return Archetype.createParent(new File(this.root, "templates/{name}".replace("{name}", name)));
            }

            public Pages pages() {
                return new Pages(this.root);
            }

            public File episodeSequencer() {
                return Archetype.createParent(new File(this.root, "episodes.seq"));
            }

            public File entityEditableAttributes() {
                return Archetype.createParent(new File(this.root, "entity-editable-attributes.tsv"));
            }

            public File translations() {
                return Archetype.createParent(new File(this.root, "translations.triplets"));
            }

            public File rolloutSequence() {
                return Archetype.createParent(new File(this.root, "rollout.seq"));
            }

            public File inventoryDefinition() {
                return Archetype.createParent(new File(this.root, "inventory.json"));
            }

            public File inventoryDefinitionImage(String name) {
                return Archetype.createParent(new File(this.root, "inventory/{name}".replace("{name}", name)));
            }

            public static class Templates {
                private final File root;

                public Templates(File parent) {
                    this.root = new File(parent, "templates");
                    this.root.mkdirs();
                }

                public File root() {
                    return this.root;
                }
            }

            public static class Pages {
                private final File root;

                public Pages(File parent) {
                    this.root = new File(parent, "pages");
                    this.root.mkdirs();
                }

                public File root() {
                    return this.root;
                }

                public File index() {
                    return Archetype.createParent(new File(this.root, "index.html"));
                }

                public File privacy() {
                    return Archetype.createParent(new File(this.root, "privacy.html"));
                }

                public File tos() {
                    return Archetype.createParent(new File(this.root, "tos.html"));
                }
            }
        }
    }

    public static class Tmp {
        private final File root;

        public Tmp(File parent) {
            this.root = new File(parent, "tmp");
            this.root.mkdirs();
        }

        public File root() {
            return this.root;
        }
    }

    public static class Logs {
        private final File root;

        public Logs(File parent) {
            this.root = new File(parent, "logs");
            this.root.mkdirs();
        }

        public File root() {
            return this.root;
        }

        public Trooper trooper() {
            return new Trooper(this.root);
        }

        public static class Trooper {
            private final File root;

            public Trooper(File parent) {
                this.root = new File(parent, "trooper");
                this.root.mkdirs();
            }

            public File root() {
                return this.root;
            }

            public File errors() {
                return Archetype.createParent(new File(this.root, "errors.txt"));
            }
        }
    }
}

