/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria.sealing;

import io.intino.alexandria.datalake.file.FileDatalake;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.sealing.EventSessionSealer;
import io.intino.alexandria.sealing.SessionSealer;
import java.io.File;

public class FileSessionSealer
implements SessionSealer {
    private final File stageDir;
    private final FileDatalake datalake;
    private final File tempDir;
    private final File treatedDir;

    public FileSessionSealer(FileDatalake datalake, File stageDir, File treatedDir) {
        this(datalake, stageDir, FileSessionSealer.tempFolder(stageDir), treatedDir);
    }

    public FileSessionSealer(FileDatalake datalake, File stageDir, File tempDir, File treatedDir) {
        this.datalake = datalake;
        this.stageDir = stageDir;
        this.tempDir = tempDir;
        this.treatedDir = treatedDir;
    }

    @Override
    public synchronized void seal(SessionSealer.TankFilter tankFilter) {
        try {
            this.sealEvents(tankFilter);
        }
        catch (Throwable e) {
            Logger.error(e);
        }
    }

    private void sealEvents(SessionSealer.TankFilter tankFilter) {
        new EventSessionSealer(this.datalake, this.stageDir, this.tempDir, this.treatedDir).seal((String t2) -> this.check(t2, tankFilter));
    }

    private boolean check(String tank, SessionSealer.TankFilter tankFilter) {
        return tankFilter.accepts(this.datalake.messageStore().tank(tank)) || tankFilter.accepts(this.datalake.measurementStore().tank(tank)) || tankFilter.accepts(this.datalake.resourceStore().tank(tank));
    }

    private static File tempFolder(File stageFolder) {
        File temp = new File(stageFolder, "temp");
        temp.mkdir();
        return temp;
    }
}

