/*
 * Decompiled with CFR 0.152.
 */
package io.intino.alexandria;

import io.intino.alexandria.MimeTypes;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public class Resource {
    private final String name;
    private final Metadata metadata;
    private final InputStreamProvider inputStreamProvider;

    public Resource(File file) {
        this(file.getName(), file);
    }

    public Resource(String name, File file) {
        this(name, InputStreamProvider.of(Objects.requireNonNull(file, "File cannot be null")));
    }

    public Resource(String name, URL url) {
        this(name, InputStreamProvider.of(Objects.requireNonNull(url, "URL cannot be null")));
    }

    public Resource(String name, byte[] bytes) {
        this(name, null, InputStreamProvider.of(Objects.requireNonNull(bytes, "Byte array cannot be null")));
    }

    public Resource(String name, String contentType, byte[] bytes) {
        this(name, contentType, InputStreamProvider.of(Objects.requireNonNull(bytes, "Byte array cannot be null")));
    }

    public Resource(String name, InputStream inputStream) {
        this(name, null, Objects.requireNonNull(inputStream, "InputStream cannot be null"));
    }

    public Resource(String name, InputStreamProvider inputStreamProvider) {
        this(name, null, inputStreamProvider);
    }

    public Resource(String name, String contentType, InputStream inputStream) {
        this(name, contentType, InputStreamProvider.of(Objects.requireNonNull(inputStream, "InputStream cannot be null")));
    }

    public Resource(String name, String contentType, InputStreamProvider inputStreamProvider) {
        this.name = this.complete(name, contentType);
        this.inputStreamProvider = Objects.requireNonNull(inputStreamProvider, "InputStreamProvider cannot be null");
        this.metadata = new Metadata(contentType);
    }

    public String name() {
        return this.name;
    }

    public String type() {
        return this.name.substring(this.name.lastIndexOf(46) + 1);
    }

    public boolean isBackedInMemory() {
        return this.inputStreamProvider.isFromMemory();
    }

    public String readAsString() throws IOException {
        return this.readAsString(Charset.defaultCharset());
    }

    public String readAsString(Charset charset) throws IOException {
        return new String(this.readAllBytes(), charset);
    }

    public byte[] bytes() throws IOException {
        return this.readAllBytes();
    }

    public byte[] readAllBytes() throws IOException {
        try (InputStream inputStream = this.open();){
            byte[] byArray = inputStream.readAllBytes();
            return byArray;
        }
    }

    public InputStream open() throws IOException {
        return this.inputStreamProvider.get();
    }

    public InputStream inputStream() throws IOException {
        return this.open();
    }

    public InputStream stream() throws IOException {
        return this.open();
    }

    public SafeReader.Builder safeReader() {
        return new SafeReader.Builder(this.inputStreamProvider);
    }

    public Metadata metadata() {
        return this.metadata;
    }

    public String toString() {
        return this.name();
    }

    private String complete(String name, String contentType) {
        if (contentType == null) {
            return name;
        }
        String extension = this.extensionOf(contentType);
        return name + (name.endsWith(extension) ? "" : extension);
    }

    private String extensionOf(String contentType) {
        return contentType == null ? "" : MimeTypes.extensionOf(contentType);
    }

    public static class SafeReader {
        private final InputStreamProvider inputStreamProvider;
        private final InputStream defaultInputStream;
        private final String defaultString;
        private final byte[] defaultByteArray;

        public SafeReader(InputStreamProvider inputStreamProvider, InputStream defaultInputStream, String defaultString, byte[] defaultByteArray) {
            this.inputStreamProvider = inputStreamProvider;
            this.defaultInputStream = defaultInputStream;
            this.defaultString = defaultString;
            this.defaultByteArray = defaultByteArray;
        }

        public String readAsString() {
            return this.readAsString(Charset.defaultCharset());
        }

        public String readAsString(Charset charset) {
            try {
                return new String(this.inputStreamProvider.get().readAllBytes(), charset);
            }
            catch (Exception ignored) {
                return this.defaultString;
            }
        }

        public byte[] bytes() {
            return this.readAllBytes();
        }

        public byte[] readAllBytes() {
            byte[] byArray;
            block8: {
                InputStream inputStream = this.inputStreamProvider.get();
                try {
                    byArray = inputStream.readAllBytes();
                    if (inputStream == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception ignored) {
                        return this.defaultByteArray;
                    }
                }
                inputStream.close();
            }
            return byArray;
        }

        public InputStream open() {
            try {
                return this.inputStreamProvider.get();
            }
            catch (IOException ignored) {
                return this.defaultInputStream;
            }
        }

        public InputStream inputStream() {
            return this.open();
        }

        public InputStream stream() {
            return this.open();
        }

        public static class Builder {
            private final InputStreamProvider provider;

            private Builder(InputStreamProvider provider) {
                this.provider = provider;
            }

            public SafeReader ofNull() {
                return new SafeReader(this.provider, null, null, null);
            }

            public SafeReader ofEmpty() {
                return new SafeReader(this.provider, InputStream.nullInputStream(), "", new byte[0]);
            }
        }
    }

    @FunctionalInterface
    public static interface InputStreamProvider {
        default public boolean isFromMemory() {
            return false;
        }

        public InputStream get() throws IOException;

        public static InputStreamProvider of(File file) {
            return () -> new BufferedInputStream(new FileInputStream(file));
        }

        public static InputStreamProvider of(URL url) {
            return url::openStream;
        }

        public static InputStreamProvider of(URI uri) throws MalformedURLException {
            return InputStreamProvider.of(uri.toURL());
        }

        public static InputStreamProvider of(final InputStream inputStream) {
            return new InputStreamProvider(){

                @Override
                public InputStream get() {
                    return inputStream;
                }

                @Override
                public boolean isFromMemory() {
                    return inputStream instanceof ByteArrayInputStream;
                }
            };
        }

        public static InputStreamProvider of(final byte[] bytes) {
            return new InputStreamProvider(){

                @Override
                public InputStream get() {
                    return new ByteArrayInputStream(bytes){

                        @Override
                        public byte[] readAllBytes() {
                            return this.buf;
                        }
                    };
                }

                @Override
                public boolean isFromMemory() {
                    return true;
                }
            };
        }
    }

    public class Metadata {
        private final Map<String, String> properties = new LinkedHashMap<String, String>(4);

        private Metadata(String contentType) {
            this.properties.put("mimeType", URLConnection.getFileNameMap().getContentTypeFor(Resource.this.name));
            this.properties.put("contentType", contentType == null ? URLConnection.guessContentTypeFromName(Resource.this.name) : contentType);
        }

        public String mimeType() {
            return this.properties.get("mimeType");
        }

        public String contentType() {
            return this.properties.getOrDefault("contentType", this.resolveContentType());
        }

        public Resource contentType(String contentType) {
            this.properties.put("contentType", contentType);
            return Resource.this;
        }

        public void putAll(Map<String, String> properties) {
            properties.forEach(this::setProperty);
        }

        public Metadata setProperty(String name, String value) {
            if (name == null || value == null) {
                return this;
            }
            this.properties.put(name, value);
            return this;
        }

        public Optional<String> getProperty(String property) {
            return Optional.ofNullable(this.properties.get(property));
        }

        public Map<String, String> properties() {
            return Collections.unmodifiableMap(this.properties);
        }

        private String resolveContentType() {
            try {
                return Resource.this.inputStreamProvider.isFromMemory() ? URLConnection.guessContentTypeFromStream(Resource.this.inputStreamProvider.get()) : null;
            }
            catch (IOException e) {
                return null;
            }
        }

        public String toString() {
            return this.properties.toString();
        }
    }
}

