/*
 * Decompiled with CFR 0.152.
 */
package com.jcraft.jsch;

import com.jcraft.jsch.AgentProxy;
import com.jcraft.jsch.Buffer;
import com.jcraft.jsch.Identity;
import com.jcraft.jsch.JSchException;
import com.jcraft.jsch.Util;

class AgentIdentity
implements Identity {
    private AgentProxy agent;
    private byte[] blob;
    private String comment;
    private String algname;

    AgentIdentity(AgentProxy agent, byte[] blob, String comment) {
        this.agent = agent;
        this.blob = blob;
        this.comment = comment;
        this.algname = Util.byte2str(new Buffer(blob).getString());
    }

    @Override
    public boolean setPassphrase(byte[] passphrase) throws JSchException {
        return true;
    }

    @Override
    public byte[] getPublicKeyBlob() {
        return this.blob;
    }

    @Override
    public byte[] getSignature(byte[] data) {
        return this.agent.sign(this.blob, data, null);
    }

    public byte[] getSignature(byte[] data, String alg) {
        return this.agent.sign(this.blob, data, alg);
    }

    @Override
    public String getAlgName() {
        return this.algname;
    }

    @Override
    public String getName() {
        return this.comment;
    }

    @Override
    public boolean isEncrypted() {
        return false;
    }

    @Override
    public void clear() {
    }
}

