/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.monitoringactivity.system;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.framework.Activity;
import io.intino.consul.monitoringactivity.system.ServiceHandler;
import io.intino.cosmos.datahub.datamarts.master.entities.Application;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.TimeUnit;

public class WinServiceHandler
implements ServiceHandler {
    private final Application application;

    public WinServiceHandler(Application application, Activity.Context context) {
        this.application = application;
    }

    @Override
    public void start() {
        WinServiceHandler.runProcess(this.net("start"));
    }

    @Override
    public void stop() {
        WinServiceHandler.runProcess(this.net("stop"));
    }

    @Override
    public boolean isRunning() {
        try {
            Process query = WinServiceHandler.runProcess(this.sc("query"));
            query.waitFor(2L, TimeUnit.SECONDS);
            return WinServiceHandler.isRunning(query);
        }
        catch (InterruptedException e) {
            Logger.error((Throwable)e);
            return false;
        }
    }

    private static boolean isRunning(Process query) {
        try {
            String result = new String(query.getInputStream().readAllBytes());
            String statusLine = result.lines().map(String::trim).filter(l -> l.startsWith("STATE")).findFirst().orElse(null);
            return statusLine != null && statusLine.contains("RUNNING");
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return false;
        }
    }

    private ProcessBuilder net(String command) {
        return new ProcessBuilder(new String[0]).directory(WinServiceHandler.installDirectory()).command("net", command, this.application.systemService());
    }

    private ProcessBuilder sc(String command) {
        return new ProcessBuilder(new String[0]).directory(WinServiceHandler.installDirectory()).command("sc", command, this.application.systemService());
    }

    private static Process runProcess(ProcessBuilder processBuilder) {
        try {
            return processBuilder.start();
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    public static File installDirectory() {
        return new File(Activity.Context.class.getProtectionDomain().getCodeSource().getLocation().getFile().replace("%20", " ")).getParentFile();
    }
}

