/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.monitoringactivity.system;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.framework.Activity;
import io.intino.consul.monitoringactivity.system.LinuxServiceHandler;
import io.intino.consul.monitoringactivity.system.ServiceHandler;
import io.intino.consul.monitoringactivity.system.WinServiceHandler;
import io.intino.cosmos.datahub.datamarts.master.entities.Application;

public class ServiceController {
    private final Activity.Context context;

    public ServiceController(Activity.Context context) {
        this.context = context;
    }

    public boolean start(Application application) {
        try {
            if (application == null) {
                return false;
            }
            if (this.isRunning(application)) {
                return true;
            }
            ServiceHandler handler = this.serviceHandler(application);
            handler.start();
            return true;
        }
        catch (Exception e) {
            if (e instanceof NullPointerException) {
                e.printStackTrace();
            } else {
                Logger.error((String)(e.getClass().getSimpleName() + ":" + e.getMessage()));
            }
            return false;
        }
    }

    public boolean stop(Application application) {
        if (application == null) {
            return false;
        }
        try {
            ServiceHandler handler = this.serviceHandler(application);
            handler.stop();
            return true;
        }
        catch (Exception e) {
            if (e instanceof NullPointerException) {
                e.printStackTrace();
            } else {
                Logger.error((String)(e.getClass().getSimpleName() + ":" + e.getMessage()));
            }
            return false;
        }
    }

    public boolean restart(Application application) {
        try {
            this.stop(application);
            Thread.sleep(1000L);
            return this.start(application);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return false;
        }
    }

    public boolean isRunning(Application application) throws Exception {
        return application != null && this.serviceHandler(application).isRunning();
    }

    public ServiceHandler serviceHandler(Application application) throws Exception {
        return this.context.system().operatingSystem().name() == Activity.System.OperatingSystem.Name.Unix ? new LinuxServiceHandler(application, this.context) : new WinServiceHandler(application, this.context);
    }
}

