/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.monitoringactivity.system;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.framework.Activity;
import io.intino.consul.monitoringactivity.system.ServiceHandler;
import io.intino.cosmos.datahub.datamarts.master.entities.Application;
import java.util.Arrays;
import java.util.Objects;

public class LinuxServiceHandler
implements ServiceHandler {
    private final Application application;
    private final Activity.Context context;
    private final Activity.System.OperatingSystem os;

    public LinuxServiceHandler(Application application, Activity.Context context) throws Exception {
        this.application = application;
        this.context = context;
        this.os = context.system().operatingSystem();
    }

    @Override
    public void start() {
        Logger.info((String)("Launching " + this.application.systemService() + "..."));
        this.systemctl("start");
        this.systemctl("enable");
    }

    @Override
    public void stop() {
        this.systemctl("stop");
        this.systemctl("disable");
        Logger.info((String)("Stopped " + this.application.systemService()));
    }

    @Override
    public boolean isRunning() {
        return Objects.requireNonNull(this.systemctl("status")).contains("active (running)");
    }

    public int exitValue() {
        String status = null;
        try {
            status = this.systemctl("status");
            String statusStr = "status=";
            return Arrays.stream(status.split("\n")).filter(l -> l.trim().startsWith("Main PID:") && l.contains("status=")).map(l -> l.split("status=")[1].replace(")", "").trim().split("/")[0]).map(Integer::parseInt).findFirst().orElse(-1000);
        }
        catch (Throwable e) {
            Logger.error((String)("Impossible to get exit value of " + this.application.name() + ";\n" + status));
            return -1000;
        }
    }

    private int pid() {
        String status = this.systemctl("status");
        String prefix = "Main PID:";
        return Arrays.stream(status.split("\n")).filter(l -> l.trim().startsWith(prefix)).map(l -> l.replace(prefix, "").trim().split(" ")[0]).map(Integer::parseInt).findFirst().orElse(-1000);
    }

    private String systemctl(String command) {
        try {
            return this.os.processRunner().execute(new String[]{"systemctl", command, this.application.systemService()});
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return null;
        }
    }
}

