/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.monitoringactivity.service.requesthandlers;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.framework.Activity;
import io.intino.consul.monitoringactivity.service.AppMonitorService;
import io.intino.consul.terminal.RequestAttendant;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import java.util.Map;

public class TagRequest
implements RequestAttendant {
    public static final String ID = "tag";
    private final Activity.Context context;
    private final Map<String, String> applications;

    public TagRequest(Activity.Context context, Map<String, String> applications) {
        this.context = context;
        this.applications = applications;
    }

    public String id() {
        return ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestAttendant.RequestResult responseTo(Message request) {
        Object object = AppMonitorService.monitor;
        synchronized (object) {
            try {
                String observable = this.parameter(request, "observable");
                String tag = this.parameter(request, ID);
                this.applications.put(observable, tag);
                return new RequestAttendant.RequestResult(true, (Object)"Tag added");
            }
            catch (JMSException e) {
                Logger.error((Throwable)e);
                return new RequestAttendant.RequestResult(false, (Object)e.getMessage());
            }
        }
    }

    public boolean isAvailable(Message message) {
        return false;
    }
}

