/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.monitoringactivity.service.requesthandlers;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.framework.Activity;
import io.intino.consul.monitoringactivity.service.AppMonitorService;
import io.intino.consul.monitoringactivity.system.ServiceController;
import io.intino.consul.terminal.RequestAttendant;
import io.intino.cosmos.datahub.datamarts.master.entities.Application;
import io.intino.cosmos.datahub.datamarts.master.entities.Observable;
import jakarta.jms.JMSException;
import jakarta.jms.Message;

public class StopServiceRequest
implements RequestAttendant {
    public static final String ID = "stopService";
    private final Activity.Context context;

    public StopServiceRequest(Activity.Context context) {
        this.context = context;
    }

    public String id() {
        return ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestAttendant.RequestResult responseTo(Message request) {
        Object object = AppMonitorService.monitor;
        synchronized (object) {
            try {
                Application a;
                Observable observable = this.observable(request);
                if (observable == null) {
                    return new RequestAttendant.RequestResult(false, (Object)"Observable not found");
                }
                if (!(observable instanceof Application) || (a = (Application)observable).systemService() == null) {
                    return new RequestAttendant.RequestResult(false, (Object)"Service not found or is not a service");
                }
                boolean start = new ServiceController(this.context).stop(a);
                return new RequestAttendant.RequestResult(start, (Object)"Service stopped successfully");
            }
            catch (JMSException e) {
                Logger.error((Throwable)e);
                return new RequestAttendant.RequestResult(false, (Object)e.getMessage());
            }
        }
    }

    public boolean isAvailable(Message message) {
        try {
            Application a;
            String id = this.parameter(message, "observable");
            if (id == null) {
                return false;
            }
            id = id.replace("\"", "");
            Observable observable = this.context.terminal().master().observable(id);
            if (!(observable instanceof Application) || (a = (Application)observable).systemService() == null) {
                return false;
            }
            return new ServiceController(this.context).isRunning(a);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return false;
        }
    }

    private Observable observable(Message request) throws JMSException {
        String id = this.parameter(request, "observable");
        if (id == null) {
            return null;
        }
        id = id.replace("\"", "");
        return this.context.terminal().master().observable(id);
    }
}

