/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.monitoringactivity.service.requesthandlers;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.scheduler.AlexandriaScheduler;
import io.intino.consul.framework.Activity;
import io.intino.consul.terminal.RequestAttendant;
import jakarta.jms.Message;
import org.quartz.SchedulerException;
import org.quartz.TriggerKey;

public class StopSamplingRequest
implements RequestAttendant {
    public static final String ID = "stopSampling";
    private final Activity.Context context;
    private final AlexandriaScheduler scheduler;
    private final Activity.Store store;

    public StopSamplingRequest(Activity.Context context, AlexandriaScheduler scheduler, Activity.Store store) {
        this.context = context;
        this.scheduler = scheduler;
        this.store = store;
    }

    public String id() {
        return ID;
    }

    public RequestAttendant.RequestResult responseTo(Message request) {
        try {
            if (!((Boolean)this.store.get("monitor#sampling-trigger", Boolean.class)).booleanValue()) {
                return new RequestAttendant.RequestResult(false, (Object)"Sampling not active");
            }
            this.scheduler.unscheduleJob(new TriggerKey("SamplingServerStatus"));
            return new RequestAttendant.RequestResult(true, (Object)"Sampling stopped");
        }
        catch (SchedulerException e) {
            Logger.error((Throwable)e);
            return new RequestAttendant.RequestResult(false, (Object)e.getMessage());
        }
    }

    public boolean isAvailable(Message message) {
        return (Boolean)this.store.get("monitor#sampling-trigger", Boolean.class) == false;
    }
}

