/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.monitoringactivity.service.requesthandlers;

import io.intino.alexandria.Json;
import io.intino.alexandria.logger.Logger;
import io.intino.consul.framework.Activity;
import io.intino.consul.monitoringactivity.actions.ComputerMeasurementAction;
import io.intino.consul.monitoringactivity.model.Consumption;
import io.intino.consul.monitoringactivity.system.ServiceController;
import io.intino.consul.terminal.RequestAttendant;
import io.intino.cosmos.datahub.datamarts.master.entities.Application;
import io.intino.cosmos.datahub.datamarts.master.entities.Observable;
import jakarta.jms.Message;
import java.util.Map;

public class StatusRequest
implements RequestAttendant {
    public static final String ID = "status";
    private final Activity.Context context;
    private final Map<String, String> tags;
    private final Activity.Store store;

    public StatusRequest(Activity.Context context, Map<String, String> tags, Activity.Store store) {
        this.context = context;
        this.tags = tags;
        this.store = store;
    }

    public String id() {
        return ID;
    }

    public RequestAttendant.RequestResult responseTo(Message request) {
        try {
            return new RequestAttendant.RequestResult(true, (Object)Json.toJson((Object)new ComputerMeasurementAction(this.context.observer(), this.context.system().operatingSystem(), this.context.hostName(), this.tags, (Consumption)this.store.get(ID, Consumption.class)).execute()));
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            return new RequestAttendant.RequestResult(false, (Object)e.getMessage());
        }
    }

    public boolean isAvailable(Message message) {
        try {
            Application a;
            String id = this.parameter(message, "observable");
            if (id == null) {
                return false;
            }
            id = id.replace("\"", "");
            Observable observable = this.context.terminal().master().observable(id);
            if (!(observable instanceof Application) || (a = (Application)observable).systemService() == null) {
                return false;
            }
            return new ServiceController(this.context).isRunning(a);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return false;
        }
    }
}

