/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.monitoringactivity.service.requesthandlers;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.scheduler.AlexandriaScheduler;
import io.intino.alexandria.scheduler.ScheduledTrigger;
import io.intino.consul.framework.Activity;
import io.intino.consul.monitoringactivity.actions.ComputerMeasurementAction;
import io.intino.consul.monitoringactivity.model.Consumption;
import io.intino.consul.terminal.RequestAttendant;
import io.intino.cosmos.datahub.measurements.monitoring.Computer;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.SimpleScheduleBuilder;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;

public class StartSamplingRequest
implements RequestAttendant {
    public static final String KEY = "SamplingServerStatus";
    public static final String ID = "startSampling";
    private final Activity.Context context;
    private final AlexandriaScheduler scheduler;
    private final Map<String, String> applications;
    private final Activity.Store store;

    public StartSamplingRequest(Activity.Context context, AlexandriaScheduler scheduler, Map<String, String> applications, Activity.Store store) {
        this.context = context;
        this.scheduler = scheduler;
        this.applications = applications;
        this.store = store;
    }

    public String id() {
        return ID;
    }

    public RequestAttendant.RequestResult responseTo(Message request) {
        try {
            if (((Boolean)this.store.get("monitor#sampling-trigger", Boolean.class)).booleanValue()) {
                return new RequestAttendant.RequestResult(true, (Object)"Already sampling");
            }
            int timeInterval = request.getIntProperty("time_interval_ms");
            JobDetail job = JobBuilder.newJob(SamplingJob.class).withIdentity("samplingServerStatus").build();
            job.getJobDataMap().put("context", (Object)this.context);
            job.getJobDataMap().put("tags", this.applications);
            job.getJobDataMap().put("store", (Object)this.store);
            SimpleTrigger trigger = (SimpleTrigger)TriggerBuilder.newTrigger().withIdentity(KEY).withSchedule((ScheduleBuilder)StartSamplingRequest.trigger(timeInterval)).build();
            this.scheduler.scheduleJob(job, (Trigger)trigger);
            this.store.put("monitor#sampling-trigger", (Object)"true");
            return new RequestAttendant.RequestResult(true, (Object)"Starting sampling");
        }
        catch (JMSException | SchedulerException e) {
            Logger.error((Throwable)e);
            return new RequestAttendant.RequestResult(false, (Object)e.getMessage());
        }
    }

    public boolean isAvailable(Message message) {
        return false;
    }

    private static SimpleScheduleBuilder trigger(int timeInterval) {
        return SimpleScheduleBuilder.simpleSchedule().withIntervalInMilliseconds((long)timeInterval).repeatForever();
    }

    public static class SamplingJob
    implements ScheduledTrigger {
        private static final AtomicBoolean running = new AtomicBoolean(false);

        public void execute(JobExecutionContext context) {
            if (running.get()) {
                return;
            }
            running.set(true);
            try {
                Activity.Context activityContext = (Activity.Context)context.getMergedJobDataMap().get((Object)"context");
                Map tags = (Map)context.getMergedJobDataMap().get((Object)"tags");
                Activity.Store store = (Activity.Store)context.getMergedJobDataMap().get((Object)"store");
                Computer computer = new ComputerMeasurementAction(activityContext.observer(), activityContext.system().operatingSystem(), activityContext.hostName(), tags, (Consumption)store.get("status", Consumption.class)).execute();
                activityContext.terminal().connector().sendQueueMessage("service.consul." + activityContext.hostName() + ".samplingstatus", computer.toString());
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
            }
            running.setRelease(false);
        }
    }
}

