/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.monitoringactivity.service;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.framework.Activity;
import io.intino.consul.monitoringactivity.service.requesthandlers.RestartServiceRequest;
import io.intino.consul.monitoringactivity.service.requesthandlers.StartServiceRequest;
import io.intino.consul.monitoringactivity.service.requesthandlers.StatusRequest;
import io.intino.consul.monitoringactivity.service.requesthandlers.StopServiceRequest;
import io.intino.consul.monitoringactivity.service.requesthandlers.TagRequest;
import io.intino.consul.terminal.RequestAttendant;
import io.intino.cosmos.datahub.messages.universe.ObservableAssertion;
import java.util.List;
import java.util.Map;

public class AppMonitorService {
    public static final Object monitor = new Object();
    public static final String SEP = "#";
    private final String activityID;
    private final Activity.Context context;
    private final Activity.Store store;
    private final Map<String, String> applications;

    public AppMonitorService(String activityID, Activity.Context context, Activity.Store store, Map<String, String> applications) {
        this.activityID = activityID;
        this.context = context;
        this.store = store;
        this.applications = applications;
    }

    public void start() {
        this.context.terminal().service().register(this.activityID + "#status", (RequestAttendant)new StatusRequest(this.context, this.applications, this.store));
        this.context.terminal().service().register(this.activityID + "#restartService", (RequestAttendant)new RestartServiceRequest(this.context));
        this.context.terminal().service().register(this.activityID + "#startService", (RequestAttendant)new StartServiceRequest(this.context));
        this.context.terminal().service().register(this.activityID + "#stopService", (RequestAttendant)new StopServiceRequest(this.context));
        this.context.terminal().service().register(this.activityID + "#tag", (RequestAttendant)new TagRequest(this.context, this.applications));
    }

    public void stop() {
        try {
            this.context.terminal().service().unregister(this.activityID + "#status");
            this.context.terminal().service().unregister(this.activityID + "#restartService");
            this.context.terminal().service().unregister(this.activityID + "#startService");
            this.context.terminal().service().unregister(this.activityID + "#stopService");
            this.context.terminal().service().unregister(this.activityID + "#tag");
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
    }

    public static List<ObservableAssertion.Operation> activityOperations() {
        return List.of(new ObservableAssertion.Operation().name("status").activity("monitoring-activity"), new ObservableAssertion.Operation().name("restartService").activity("monitoring-activity"), new ObservableAssertion.Operation().name("stopService").activity("monitoring-activity"), new ObservableAssertion.Operation().name("startService").activity("monitoring-activity"));
    }
}

