/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.monitoringactivity.sentinels;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.scheduler.AlexandriaScheduler;
import io.intino.consul.framework.Activity;
import io.intino.consul.monitoringactivity.sentinels.RefreshAppsSentinel;
import io.intino.consul.monitoringactivity.sentinels.ScheduleMeasurementsSentinel;
import io.intino.consul.monitoringactivity.sentinels.ScheduleStatusSentinel;
import java.util.Map;
import java.util.Set;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.TriggerBuilder;

public class Sentinels {
    public static final Object monitor = new Object();

    private Sentinels() {
    }

    public static void init(String id, AlexandriaScheduler scheduler, Activity.Context context, Activity.Store store, Map<String, String> tags) {
        try {
            Sentinels.monitoringStatus(id, scheduler, context, store, tags);
            Sentinels.monitoringMeasurements(id, scheduler, context, store, tags);
            Sentinels.refreshApps(id, scheduler, context, store, tags);
        }
        catch (Exception e) {
            Logger.error((String)e.getMessage());
        }
    }

    private static void monitoringStatus(String id, AlexandriaScheduler scheduler, Activity.Context context, Activity.Store store, Map<String, String> tags) throws SchedulerException {
        JobDetail job = JobBuilder.newJob(ScheduleStatusSentinel.class).withIdentity(id + "-scheduleStatus").build();
        job.getJobDataMap().put("context", (Object)context);
        job.getJobDataMap().put("store", (Object)store);
        job.getJobDataMap().put("tags", tags);
        scheduler.scheduleJob(job, Set.of((CronTrigger)TriggerBuilder.newTrigger().withIdentity(id + "-ScheduleStatusSentinel").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)"0 0/1 * 1/1 * ? *")).build()), true);
    }

    private static void monitoringMeasurements(String id, AlexandriaScheduler scheduler, Activity.Context context, Activity.Store store, Map<String, String> tags) throws SchedulerException {
        JobDetail job = JobBuilder.newJob(ScheduleMeasurementsSentinel.class).withIdentity(id + "-scheduleMeasurements").build();
        job.getJobDataMap().put("context", (Object)context);
        job.getJobDataMap().put("store", (Object)store);
        job.getJobDataMap().put("tags", tags);
        scheduler.scheduleJob(job, Set.of((CronTrigger)TriggerBuilder.newTrigger().withIdentity(id + "-ScheduleMeasurementsSentinel").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)"0 0/5 * 1/1 * ? *")).build()), true);
    }

    private static void refreshApps(String id, AlexandriaScheduler scheduler, Activity.Context context, Activity.Store store, Map<String, String> tags) throws SchedulerException {
        JobDetail job = JobBuilder.newJob(RefreshAppsSentinel.class).withIdentity(id + "-refreshApps").build();
        job.getJobDataMap().put("context", (Object)context);
        job.getJobDataMap().put("store", (Object)store);
        job.getJobDataMap().put("tags", tags);
        scheduler.scheduleJob(job, Set.of((CronTrigger)TriggerBuilder.newTrigger().withIdentity(id + "-RefreshAppsSentinel").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)"0 0 12 1/1 * ? *")).build()), true);
    }
}

