/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.monitoringactivity.sentinels;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.message.Message;
import io.intino.alexandria.scheduler.ScheduledTrigger;
import io.intino.consul.framework.Activity;
import io.intino.consul.monitoringactivity.actions.ApplicationAssertionCollector;
import io.intino.consul.monitoringactivity.sentinels.Sentinels;
import io.intino.consul.terminal.Terminal;
import io.intino.cosmos.datahub.datamarts.master.MasterDatamart;
import io.intino.cosmos.datahub.datamarts.master.entities.Application;
import io.intino.cosmos.datahub.datamarts.master.entities.ApplicationJava;
import io.intino.cosmos.datahub.messages.monitoring.Status;
import io.intino.cosmos.datahub.messages.universe.ApplicationAssertion;
import io.intino.cosmos.datahub.messages.universe.ApplicationJavaAssertion;
import io.intino.sumus.chronos.State;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.quartz.JobExecutionContext;

public class ScheduleStatusSentinel
implements ScheduledTrigger {
    public static final String ONLINE_SIGNAL = "online";

    public void execute(JobExecutionContext context) {
        try {
            new StatusAction((Activity.Context)context.getMergedJobDataMap().get((Object)"context"), (Activity.Store)context.getMergedJobDataMap().get((Object)"store"), (Map)context.getMergedJobDataMap().get((Object)"tags")).execute();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
    }

    public static class StatusAction {
        public static final String SYSTEM = "System";
        public static final String LINE_STORE_SUFFIX = "\u0000line";
        private final Activity.Context context;
        private final Activity.Store store;
        private final Map<String, String> tags;
        private final Terminal terminal;

        public StatusAction(Activity.Context context, Activity.Store store, Map<String, String> tags) {
            this.context = context;
            this.store = store;
            this.terminal = context.terminal();
            this.tags = tags;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            Object object = Sentinels.monitor;
            synchronized (object) {
                try {
                    ApplicationAssertionCollector assertionCollector = new ApplicationAssertionCollector(this.context, this.store, this.tags);
                    List<ApplicationJavaAssertion> javaApps = assertionCollector.javaApplications();
                    List<ApplicationAssertion> apps = assertionCollector.applications();
                    this.publish(javaApps, apps);
                    this.save(javaApps);
                    this.save(apps);
                }
                catch (Throwable e) {
                    Logger.error((Throwable)e);
                }
            }
        }

        private void publish(List<? extends ApplicationAssertion> javaApps, List<ApplicationAssertion> apps) {
            this.publishAssertions(javaApps);
            this.publishAssertions(apps);
            this.publishStatus(javaApps);
            this.publishStatus(apps);
            this.offlineOfNotFoundApps(javaApps, apps);
            this.refreshStoredStatus(javaApps, apps);
        }

        private void offlineOfNotFoundApps(List<? extends ApplicationAssertion> javaApps, List<ApplicationAssertion> apps) {
            Map<String, ApplicationAssertion> javaAppsMap = javaApps.stream().filter(StatusAction::isPublishable).collect(Collectors.toMap(ApplicationAssertion::id, ja -> ja));
            Map<String, ApplicationAssertion> appsMap = apps.stream().filter(StatusAction::isPublishable).collect(Collectors.toMap(ApplicationAssertion::id, ja -> ja));
            this.terminal.master().applicationJavas().filter(ja -> ja.observer() != null && this.context.observer().equals(ja.observer().id())).filter(this::isPublishable).filter(ja -> {
                Boolean line = (Boolean)this.store.get(ja.id() + LINE_STORE_SUFFIX, Boolean.class);
                return !javaAppsMap.containsKey(ja.id()) && (line == null || line != false);
            }).forEach(ja -> {
                this.terminal.publish((Event)this.status(ja.id(), List.of()));
                this.store.put(ja.id() + LINE_STORE_SUFFIX, (Object)false);
            });
            this.terminal.master().applications().filter(a -> !(a instanceof ApplicationJava)).filter(a -> a.observer().id().equals(this.context.observer())).filter(this::isPublishable).filter(a -> {
                Boolean line = (Boolean)this.store.get(a.id() + LINE_STORE_SUFFIX, Boolean.class);
                return !appsMap.containsKey(a.id()) && (line == null || line != false);
            }).forEach(a -> {
                this.terminal.publish((Event)this.status(a.id(), List.of()));
                this.store.put(a.id() + LINE_STORE_SUFFIX, (Object)false);
            });
        }

        private void publishAssertions(List<? extends ApplicationAssertion> apps) {
            apps.stream().filter(a -> !this.withOutTs(a.toMessage()).equals(this.last(a.name()))).forEach(a -> {
                if (StatusAction.isPublishable(a)) {
                    this.terminal.publish((Event)a);
                } else if (!a.tags().contains(SYSTEM)) {
                    this.tags.put(a.name(), "unknown");
                }
            });
        }

        private void publishStatus(List<? extends ApplicationAssertion> apps) {
            apps.stream().filter(StatusAction::isPublishable).forEach(app -> {
                MasterDatamart.ReelNode reelNode = this.terminal.master().statusReel(app.id());
                Boolean line = (Boolean)this.store.get(app.id() + LINE_STORE_SUFFIX, Boolean.class);
                if (line == null || !reelNode.exists() || !line.booleanValue() || State.Off.equals((Object)StatusAction.state(reelNode))) {
                    this.terminal.publish((Event)this.status(app.id(), List.of(ScheduleStatusSentinel.ONLINE_SIGNAL)));
                }
                this.store.put(app.id() + LINE_STORE_SUFFIX, (Object)true);
            });
        }

        private static State state(MasterDatamart.ReelNode reelNode) {
            try {
                return reelNode.stateOf(ScheduleStatusSentinel.ONLINE_SIGNAL);
            }
            catch (MasterDatamart.ReelNotAvailableException e) {
                return null;
            }
        }

        private void refreshStoredStatus(List<? extends ApplicationAssertion> javaApps, List<ApplicationAssertion> apps) {
            List<String> offlineApps = this.store.keys().filter(k -> k.endsWith(LINE_STORE_SUFFIX)).map(k -> k.replace(LINE_STORE_SUFFIX, "")).filter(k -> javaApps.stream().noneMatch(a -> a.id().equals(k)) && apps.stream().noneMatch(a -> a.id().equals(k))).toList();
            offlineApps.forEach(k -> this.store.put(k + LINE_STORE_SUFFIX, (Object)false));
        }

        private Status status(String id, List<String> signals) {
            return new Status(this.context.observer()).observable(id).group(ScheduleStatusSentinel.ONLINE_SIGNAL).signals(signals);
        }

        private static boolean isPublishable(ApplicationAssertion a) {
            return !a.tags().contains("unknown") && !a.tags().contains(SYSTEM);
        }

        private boolean isPublishable(Application a) {
            return a.tags() != null && !a.tags().contains("unknown") && !a.tags().contains(SYSTEM);
        }

        private void save(List<? extends ApplicationAssertion> apps) {
            apps.forEach(a -> this.store.put(a.name(), (Object)this.withOutTs(a.toMessage())));
        }

        private String last(String name) {
            return (String)this.store.get(name, String.class);
        }

        private String withOutTs(Message message) {
            return message.toString().replaceFirst("\nts:.*\n", "\n");
        }
    }
}

