/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.monitoringactivity.sentinels;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.scheduler.ScheduledTrigger;
import io.intino.consul.framework.Activity;
import io.intino.consul.monitoringactivity.actions.ApplicationAssertionCollector;
import io.intino.consul.monitoringactivity.actions.ComputerMeasurementAction;
import io.intino.consul.monitoringactivity.actions.SchemaMapper;
import io.intino.consul.monitoringactivity.model.Consumption;
import io.intino.consul.monitoringactivity.sentinels.Sentinels;
import io.intino.consul.terminal.Terminal;
import io.intino.cosmos.datahub.measurements.monitoring.Application;
import io.intino.cosmos.datahub.measurements.monitoring.Computer;
import io.intino.cosmos.datahub.messages.universe.ApplicationJavaAssertion;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.quartz.JobExecutionContext;

public class ScheduleMeasurementsSentinel
implements ScheduledTrigger {
    public void execute(JobExecutionContext context) {
        try {
            new MeasurementsAction((Activity.Context)context.getMergedJobDataMap().get((Object)"context"), (Activity.Store)context.getMergedJobDataMap().get((Object)"store"), (Map)context.getMergedJobDataMap().get((Object)"tags")).execute();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
    }

    public static class MeasurementsAction {
        public static final String SYSTEM = "System";
        private final Activity.Context context;
        private final Activity.Store store;
        private final Map<String, String> tags;
        private final List<? extends Activity.System.OSProcess> processes;
        private final Terminal terminal;
        private final SchemaMapper schemaMapper;
        private final Activity.System.OperatingSystem operatingSystem;

        public MeasurementsAction(Activity.Context context, Activity.Store store, Map<String, String> tags) throws Exception {
            this.context = context;
            this.store = store;
            this.terminal = context.terminal();
            this.tags = tags;
            this.operatingSystem = context.system().operatingSystem();
            this.processes = this.operatingSystem.processes();
            this.schemaMapper = new SchemaMapper(context.hostName(), context.observer(), store, tags);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            Object object = Sentinels.monitor;
            synchronized (object) {
                try {
                    this.measurements();
                }
                catch (Throwable e) {
                    Logger.error((Throwable)e);
                }
            }
        }

        private void measurements() throws Exception {
            Computer computer = new ComputerMeasurementAction(this.context.observer(), this.operatingSystem, this.context.hostName(), this.tags, (Consumption)this.store.get("status", Consumption.class)).execute();
            this.terminal.publish((Event)computer);
            this.store.put("status", (Object)new Consumption(computer.ts(), computer.usageRAM(), computer.usageHDD(), computer.usageCPU(), computer.temperatureKernel(), computer.temperatureExternal(), computer.dataReceived(), computer.dataSent(), (int)computer.usageFiles(), (int)computer.usageThreads()));
            ApplicationAssertionCollector assertionCollector = new ApplicationAssertionCollector(this.context, this.store, this.tags);
            this.applicationsMeasurements(assertionCollector.javaApplications()).forEach(arg_0 -> ((Terminal)this.terminal).publish(arg_0));
            ApplicationJavaAssertion observerAssertion = assertionCollector.observerAssertion();
            Activity.System.OSProcess osProcess = this.processes.stream().filter(p -> observerAssertion.pids().contains(p.processID())).findFirst().orElse(null);
            if (osProcess != null) {
                this.terminal.publish((Event)this.schemaMapper.mapMeasurement(List.of(osProcess), observerAssertion));
            }
        }

        public Stream<Application> applicationsMeasurements(List<ApplicationJavaAssertion> javaApps) {
            Map<String, List<Activity.System.OSProcess>> processes = this.processes.stream().filter(p -> !p.isOSProcess()).filter(p -> !this.shouldBeDiscarded((Activity.System.OSProcess)p, javaApps)).collect(Collectors.groupingBy(osProcess -> MeasurementsAction.nameOf(osProcess, javaApps)));
            return processes.values().stream().map(ps -> this.schemaMapper.mapMeasurement((List<Activity.System.OSProcess>)ps, MeasurementsAction.javaAssertion(javaApps, ps)));
        }

        private boolean shouldBeDiscarded(Activity.System.OSProcess p, List<ApplicationJavaAssertion> javaApps) {
            String name = MeasurementsAction.nameOf(p, javaApps);
            return !this.tags.containsKey(name) || "unknown".equalsIgnoreCase(this.tags.get(name)) || SYSTEM.equalsIgnoreCase(this.tags.get(name));
        }

        private static String nameOf(Activity.System.OSProcess p, List<ApplicationJavaAssertion> javaApps) {
            ApplicationJavaAssertion jp = MeasurementsAction.javaAssertion(javaApps, List.of(p));
            return jp == null ? p.name() : jp.name();
        }

        private static ApplicationJavaAssertion javaAssertion(List<ApplicationJavaAssertion> javaApps, List<Activity.System.OSProcess> ps) {
            return javaApps.stream().filter(jp -> ps.stream().anyMatch(p -> p.processID() == ((Integer)jp.pids().get(0)).intValue())).findFirst().orElse(null);
        }
    }
}

