/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.monitoringactivity.sentinels;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.scheduler.ScheduledTrigger;
import io.intino.consul.framework.Activity;
import io.intino.consul.framework.utils.Utils;
import io.intino.consul.monitoringactivity.actions.JavaProcessMonitor;
import java.util.List;
import java.util.Map;
import org.quartz.JobExecutionContext;

public class RefreshAppsSentinel
implements ScheduledTrigger {
    public static final String OBSERVER_COORS = "io.intino.consul:container";

    public void execute(JobExecutionContext context) {
        try {
            this.refreshApplications((Activity.Context)context.getMergedJobDataMap().get((Object)"context"), (Map)context.getMergedJobDataMap().get((Object)"tags"));
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
    }

    public void refreshApplications(Activity.Context context, Map<String, String> apps) {
        try {
            String host = context.initialConfiguration().getOrDefault("remote-server", "localhost");
            List<Activity.System.OSProcess> javaProcesses = context.system().operatingSystem().processes().stream().filter(p -> p.name().equals("java")).toList();
            JavaProcessMonitor javaProcessMonitor = new JavaProcessMonitor(context, context.hostName());
            Map<Integer, Utils.Coors> javaPids = javaProcessMonitor.pids(host, javaProcesses);
            Activity.System.OperatingSystem os = context.system().operatingSystem();
            os.processes().stream().filter(p -> !p.isOSProcess()).filter(p -> !this.isMine(p.processID(), javaProcessMonitor)).map(p -> p.name().equals("java") ? this.javaProcessOf((Activity.System.OSProcess)p, javaPids) : p.name()).filter(p -> !apps.containsKey(p) && !p.equals(OBSERVER_COORS) && !p.equals("java")).forEach(p -> apps.put((String)p, "unknown"));
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
        }
    }

    private boolean isMine(int pid, JavaProcessMonitor javaPids) {
        return javaPids.consulApplicationInfo().pids().contains(pid);
    }

    private String javaProcessOf(Activity.System.OSProcess p, Map<Integer, Utils.Coors> pids) {
        Utils.Coors coors = pids.get(p.processID());
        return coors == null ? p.name() : coors.name();
    }
}

