/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.monitoringactivity.actions;

import io.intino.consul.framework.Activity;
import io.intino.consul.framework.utils.Utils;
import io.intino.consul.monitoringactivity.model.AppConsumption;
import io.intino.cosmos.datahub.measurements.monitoring.Application;
import io.intino.cosmos.datahub.messages.universe.ApplicationAssertion;
import io.intino.cosmos.datahub.messages.universe.ApplicationJavaAssertion;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.Instant;
import java.util.Comparator;
import java.util.List;
import java.util.Map;

public class SchemaMapper {
    public static final String UNKNOWN = "unknown";
    public static final String STATUS_SUFFIX = "\u0000status";
    private final String hostName;
    private final String observer;
    private final Activity.Store store;
    private final Map<String, String> tags;

    public SchemaMapper(String hostName, String observer, Activity.Store store, Map<String, String> tags) {
        this.hostName = hostName;
        this.observer = observer;
        this.store = store;
        this.tags = tags;
    }

    public ApplicationAssertion map(String observer, String hostName, List<Activity.System.OSProcess> ps) {
        String id = hostName + "." + ps.get(0).name();
        ApplicationAssertion assertion = new ApplicationAssertion(observer + "." + id, id).name(ps.get(0).name());
        return this.fill(assertion, hostName, ps);
    }

    public ApplicationAssertion fill(ApplicationAssertion app, String computerName, List<Activity.System.OSProcess> ps) {
        Activity.System.OSProcess p = ps.stream().min(Comparator.comparing(Activity.System.OSProcess::startTime)).get();
        Activity.System.OSProcess serviceProcess = ps.stream().filter(Activity.System.OSProcess::isSystemService).findFirst().orElse(null);
        return (ApplicationAssertion)app.startingTime(Instant.ofEpochMilli(p.startTime())).user(p.user()).pids(ps.stream().map(Activity.System.OSProcess::processID).toList()).state(ApplicationAssertion.State.valueOf((String)p.state().name())).commandLine(p.commandLine()).systemService(serviceProcess == null ? null : serviceProcess.systemServiceName()).tags(List.of(this.tags.getOrDefault(app.name(), UNKNOWN))).container(computerName).observer(this.observer).model(app instanceof ApplicationJavaAssertion ? "application.java" : "application").label(app.name());
    }

    public Application mapMeasurement(List<Activity.System.OSProcess> ps, ApplicationJavaAssertion javaApp) {
        String id = javaApp != null ? javaApp.id() : this.hostName + "." + ps.get(0).name();
        AppConsumption lastStatus = this.lastConsumption(id);
        long totalDataRead = Utils.inMb((long)ps.stream().mapToLong(Activity.System.OSProcess::bytesRead).sum());
        long totalDataWritten = Utils.inMb((long)ps.stream().mapToLong(Activity.System.OSProcess::bytesWritten).sum());
        Application appStatus = new Application(this.observer + "?sensor=" + id).usageRAM((double)Utils.inMb((long)ps.stream().mapToLong(Activity.System.OSProcess::residentSetSize).sum())).usageCPU(SchemaMapper.format(ps.stream().mapToDouble(p -> 100.0 * (double)(p.kernelTime() + p.userTime()) / (double)p.upTime()).average().getAsDouble()).doubleValue()).usageThreads((double)ps.stream().mapToLong(Activity.System.OSProcess::threadCount).sum()).usageFiles((double)ps.stream().mapToLong(Activity.System.OSProcess::openFiles).sum()).dataRead((double)totalDataRead - (lastStatus == null ? 0.0 : lastStatus.dataRead())).dataWritten((double)totalDataWritten - (lastStatus == null ? 0.0 : lastStatus.dataWritten()));
        this.save(id, appStatus, totalDataRead, totalDataWritten);
        return appStatus;
    }

    private void save(String id, Application appStatus, long totalDataRead, long totalDataWritten) {
        this.store.put(id + STATUS_SUFFIX, (Object)new AppConsumption(appStatus.ts(), appStatus.usageRAM(), appStatus.usageCPU(), (int)appStatus.usageFiles(), (int)appStatus.usageThreads(), totalDataRead, totalDataWritten));
    }

    private AppConsumption lastConsumption(String id) {
        return (AppConsumption)this.store.get(id + STATUS_SUFFIX, AppConsumption.class);
    }

    public static Double format(double v) {
        return new BigDecimal(v).setScale(4, RoundingMode.DOWN).doubleValue();
    }
}

