/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.monitoringactivity.actions;

import com.sun.tools.attach.AttachNotSupportedException;
import com.sun.tools.attach.VirtualMachine;
import io.intino.alexandria.jmx.JMXClient;
import io.intino.alexandria.logger.Logger;
import io.intino.consul.framework.Activity;
import io.intino.consul.framework.utils.JMXConnection;
import io.intino.consul.framework.utils.Utils;
import io.intino.cosmos.datahub.messages.universe.ApplicationJavaAssertion;
import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.RuntimeMXBean;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.management.JMX;
import javax.management.MBeanServer;

public class JavaProcessMonitor {
    private final String observer;
    private final String hostName;
    private final ApplicationJavaAssertion consulInfo;
    private final Activity.System system;

    public JavaProcessMonitor(Activity.Context context, String hostName) {
        this.system = context.system();
        this.observer = context.observer();
        this.hostName = hostName;
        this.consulInfo = this.consulApplicationInfo();
    }

    public List<ApplicationJavaAssertion> extractInfo(String host, List<? extends Activity.System.OSProcess> javaProcesses) {
        return new ArrayList<ApplicationJavaAssertion>(this.connections(host, javaProcesses).filter(Objects::nonNull).map(this::extractInfoOfApp).filter(Objects::nonNull).filter(a -> !a.pids().contains(this.consulInfo.pids().get(0))).filter(JavaProcessMonitor.distinctByKey(p -> p.pids().get(0))).toList());
    }

    public Map<Integer, Utils.Coors> pids(String host, List<? extends Activity.System.OSProcess> javaProcesses) {
        ApplicationJavaAssertion consulInfo = this.consulApplicationInfo();
        HashMap<Integer, Utils.Coors> map = new HashMap<Integer, Utils.Coors>(this.connections(host, javaProcesses).map(this::nameAndPid).filter(obj -> Objects.nonNull(obj) && obj.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (p1, p2) -> p2)));
        map.put((Integer)consulInfo.pids().get(0), new Utils.Coors(consulInfo.groupId(), consulInfo.artifactId(), consulInfo.version()));
        return map;
    }

    private Stream<String> connections(String host, List<? extends Activity.System.OSProcess> javaProcesses) {
        String LOCAL_CONNECTOR_ADDRESS = "com.sun.management.jmxremote.localConnectorAddress";
        HashSet urls = new HashSet(JMXClient.allJMXLocalURLs().values());
        List<String> urlsOfJavaProcesses = javaProcesses.stream().map(p -> {
            try {
                VirtualMachine vm = VirtualMachine.attach(String.valueOf(p.processID()));
                vm.startLocalManagementAgent();
                Properties props = vm.getAgentProperties();
                return props.getProperty("com.sun.management.jmxremote.localConnectorAddress");
            }
            catch (AttachNotSupportedException | IOException e) {
                return this.tryRemoteConnection(host, (Activity.System.OSProcess)p);
            }
        }).toList();
        urls.addAll(urlsOfJavaProcesses);
        return urls.stream().filter(Objects::nonNull);
    }

    private String tryRemoteConnection(String host, Activity.System.OSProcess p) {
        Map<String, String> vmArgs = JavaProcessMonitor.extractVMArgs(p.commandLine());
        if (vmArgs.containsKey("com.sun.management.jmxremote.port")) {
            return host + "\u0000\u0000" + vmArgs.get("com.sun.management.jmxremote.port");
        }
        return null;
    }

    public static Map<String, String> extractVMArgs(String commandLine) {
        HashMap<String, String> vmProperties = new HashMap<String, String>();
        Pattern pattern = Pattern.compile("-D(\\S+)=([^\\s-]+)");
        Matcher matcher = pattern.matcher(commandLine);
        while (matcher.find()) {
            String key = matcher.group(1);
            String value = matcher.group(2);
            vmProperties.put(key, value);
        }
        return vmProperties;
    }

    public static <T> Predicate<T> distinctByKey(Function<? super T, Object> keyExtractor) {
        ConcurrentHashMap map = new ConcurrentHashMap();
        return t -> map.putIfAbsent(keyExtractor.apply(t), Boolean.TRUE) == null;
    }

    private Map.Entry<Integer, Utils.Coors> nameAndPid(String chain) {
        AbstractMap.SimpleEntry<Integer, Utils.Coors> simpleEntry;
        block8: {
            JMXConnection connection = JMXConnection.connection((Activity.System)this.system, (String)chain);
            try {
                RuntimeMXBean runtime = (RuntimeMXBean)connection.get().mBean(RuntimeMXBean.class, ManagementFactory.getRuntimeMXBean().getObjectName());
                simpleEntry = new AbstractMap.SimpleEntry<Integer, Utils.Coors>((int)runtime.getPid(), this.coors(runtime));
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Logger.error((String)e.getMessage());
                    return null;
                }
            }
            connection.close();
        }
        return simpleEntry;
    }

    private Utils.Coors coors(RuntimeMXBean runtime) {
        return this.coors(Arrays.asList(runtime.getClassPath().split(File.pathSeparator)));
    }

    private ApplicationJavaAssertion extractInfoOfApp(String chain) {
        ApplicationJavaAssertion applicationJavaAssertion;
        block8: {
            JMXConnection connection = JMXConnection.connection((Activity.System)this.system, (String)chain);
            try {
                applicationJavaAssertion = this.createJavaApp(connection.get());
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    return null;
                }
            }
            connection.close();
        }
        return applicationJavaAssertion;
    }

    public ApplicationJavaAssertion consulApplicationInfo() {
        MBeanServer server = ManagementFactory.getPlatformMBeanServer();
        MemoryMXBean memoryMXBean = JMX.newMXBeanProxy(server, ManagementFactory.getMemoryMXBean().getObjectName(), MemoryMXBean.class, true);
        RuntimeMXBean runtimeMXBean = JMX.newMXBeanProxy(server, ManagementFactory.getRuntimeMXBean().getObjectName(), RuntimeMXBean.class, true);
        Utils.Coors coors = new Utils.Coors("io.intino.consul", "container", Utils.currentVersion());
        return this.fill(memoryMXBean, runtimeMXBean, Arrays.asList(runtimeMXBean.getClassPath().split(File.pathSeparator)), coors, this.observer);
    }

    private ApplicationJavaAssertion createJavaApp(JMXClient.JMXConnection connection) {
        MemoryMXBean memory = (MemoryMXBean)connection.mBean(MemoryMXBean.class, ManagementFactory.getMemoryMXBean().getObjectName());
        RuntimeMXBean runtime = (RuntimeMXBean)connection.mBean(RuntimeMXBean.class, ManagementFactory.getRuntimeMXBean().getObjectName());
        List<String> classpath = Arrays.asList(runtime.getClassPath().split(File.pathSeparator));
        Utils.Coors coors = this.coors(classpath);
        if (coors == null) {
            return null;
        }
        return this.fill(memory, runtime, classpath, coors);
    }

    private ApplicationJavaAssertion fill(MemoryMXBean memory, RuntimeMXBean runtime, List<String> classpath, Utils.Coors coors) {
        return this.fill(memory, runtime, classpath, coors, this.hostName + "." + coors.name());
    }

    private ApplicationJavaAssertion fill(MemoryMXBean memory, RuntimeMXBean runtime, List<String> classpath, Utils.Coors coors, String id) {
        ApplicationJavaAssertion assertion = (ApplicationJavaAssertion)new ApplicationJavaAssertion((String)(this.observer.equals(id) ? this.observer : this.observer + "." + id), id).maxMemory(Integer.valueOf((int)(memory.getHeapMemoryUsage().getMax() / 0x100000L))).minMemory(Integer.valueOf((int)(memory.getHeapMemoryUsage().getInit() / 0x100000L))).version(coors.version()).groupId(coors.groupId()).artifactId(coors.artifactId()).classpath(classpath).jvmParameter(runtime.getInputArguments()).mainArtifact(classpath.isEmpty() ? null : new File(classpath.get(0)).getName()).jvmVersion(runtime.getVmVersion()).name(coors.name()).startingTime(Instant.now().minus(runtime.getUptime(), ChronoUnit.MILLIS)).pids(List.of(Integer.valueOf(JavaProcessMonitor.pid(runtime)))).label(coors.name()).container(this.hostName).observer(this.observer);
        Integer jmxPort = runtime.getInputArguments().stream().filter(a -> a.startsWith("-Dcom.sun.management.jmxremote.port=")).findFirst().map(p -> Integer.parseInt(p.split("=")[1])).orElse(null);
        if (jmxPort != null) {
            assertion.jmxPort(jmxPort);
        }
        return assertion;
    }

    private Utils.Coors coors(List<String> classpath) {
        if (classpath.isEmpty()) {
            return new Utils.Coors("", "", "");
        }
        File mainArtifact = new File(classpath.get(0));
        return Utils.coors((Activity.System)this.system, (File)mainArtifact);
    }

    private static int pid(RuntimeMXBean runtime) {
        try {
            return (int)runtime.getPid();
        }
        catch (Throwable e) {
            return 0;
        }
    }
}

