/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.monitoringactivity.actions;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.framework.Activity;
import io.intino.consul.monitoringactivity.model.Consumption;
import io.intino.cosmos.datahub.measurements.monitoring.Computer;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class ComputerMeasurementAction {
    private final String observer;
    private final Activity.System.OperatingSystem os;
    private final String hostName;
    private final Map<String, String> tags;
    private final Consumption last;

    public ComputerMeasurementAction(String observer, Activity.System.OperatingSystem os, String hostName, Map<String, String> tags, Consumption last) {
        this.observer = observer;
        this.os = os;
        this.hostName = hostName;
        this.tags = tags;
        this.last = last;
    }

    public Computer execute() {
        try {
            Activity.System.Measurements measurements = this.os.measurements();
            List processes = this.os.processes();
            return new Computer(this.observer + "?sensor=" + this.hostName).usageRAM((double)measurements.usageRAM()).usageHDD((double)measurements.usageHDD()).usageCPU(Math.max(0.0, measurements.usageCPU())).usageSystem(measurements.usageSystem()).usageFiles((double)measurements.usageFiles()).usageThreads((double)((int)measurements.usageThreads())).temperatureKernel(measurements.temperatureKernel()).dataReceived((double)measurements.dataReceived() - (this.last != null ? this.last.dataReceived() : 0.0)).dataSent((double)((int)measurements.dataSent()) - (this.last != null ? this.last.dataSent() : 0.0)).applicationsUnknown(this.unknownApplications(processes)).applicationsSystem((double)ComputerMeasurementAction.systemApplications(processes)).applicationsKnown(this.knownApplications(processes));
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    private static long systemApplications(List<? extends Activity.System.OSProcess> processes) {
        return processes.stream().filter(Activity.System.OSProcess::isOSProcess).count();
    }

    private double unknownApplications(List<? extends Activity.System.OSProcess> processes) {
        return this.processesNames(processes).filter(p -> "unknown".equals(this.tags.get(p))).count();
    }

    private double knownApplications(List<? extends Activity.System.OSProcess> processes) {
        return this.processesNames(processes).filter(p -> !"unknown".equals(this.tags.get(p))).count();
    }

    private Stream<String> processesNames(List<? extends Activity.System.OSProcess> processes) {
        try {
            return processes.stream().map(Activity.System.OSProcess::name).distinct();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return Stream.of(new String[0]);
        }
    }
}

