/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.monitoringactivity.actions;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.framework.Activity;
import io.intino.consul.monitoringactivity.actions.JavaProcessMonitor;
import io.intino.consul.monitoringactivity.actions.SchemaMapper;
import io.intino.consul.monitoringactivity.service.AppMonitorService;
import io.intino.cosmos.datahub.datamarts.master.entities.ApplicationJava;
import io.intino.cosmos.datahub.datamarts.master.entities.Observable;
import io.intino.cosmos.datahub.messages.universe.ApplicationAssertion;
import io.intino.cosmos.datahub.messages.universe.ApplicationJavaAssertion;
import io.intino.cosmos.datahub.messages.universe.ObservableAssertion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ApplicationAssertionCollector {
    private final Activity.Context context;
    private final List<? extends Activity.System.OSProcess> processes;
    private final SchemaMapper schemaMapper;
    private final JavaProcessMonitor javaProcessMonitor;
    private final String host;
    private List<ApplicationJavaAssertion> javaApps = null;

    public ApplicationAssertionCollector(Activity.Context context, Activity.Store store, Map<String, String> tags) throws Exception {
        this.context = context;
        this.processes = context.system().operatingSystem().processes();
        this.host = context.initialConfiguration().getOrDefault("remote-server", "localhost");
        this.schemaMapper = new SchemaMapper(context.hostName(), context.observer(), store, tags);
        this.javaProcessMonitor = new JavaProcessMonitor(context, context.hostName());
    }

    public List<ApplicationJavaAssertion> javaApplications() {
        List<ApplicationJavaAssertion> list = this.javaProcessMonitor.extractInfo(this.host, this.processes.stream().filter(p -> p.name().equals("java")).toList()).stream().filter(app -> !app.pids().contains(0)).map((? super T p) -> (ApplicationJavaAssertion)this.schemaMapper.fill((ApplicationAssertion)p, this.context.hostName(), this.osProcess((Integer)p.pids().get(0)))).map((? super T a) -> (ApplicationJavaAssertion)a.operationList(this.appOperations((ApplicationJavaAssertion)a))).toList();
        this.javaApps = list;
        return list;
    }

    public ApplicationJavaAssertion observerAssertion() {
        return this.javaProcessMonitor.consulApplicationInfo();
    }

    public List<ApplicationAssertion> applications() {
        if (this.javaApps == null) {
            this.javaApplications();
        }
        try {
            Map<String, List<Activity.System.OSProcess>> processes = this.processes.stream().filter(p -> !p.isOSProcess()).collect(Collectors.groupingBy(Activity.System.OSProcess::name));
            if (processes.isEmpty()) {
                Logger.error((String)"Processes are empty");
            }
            return processes.values().stream().filter(ps -> !ps.isEmpty()).map((? super T p) -> this.schemaMapper.map(this.context.observer(), this.context.hostName(), (List<Activity.System.OSProcess>)p)).filter(p -> !ApplicationAssertionCollector.isIn(this.javaApps, p)).toList();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return List.of();
        }
    }

    private List<ObservableAssertion.Operation> appOperations(ApplicationJavaAssertion a) {
        ApplicationJava javaApplication = this.context.terminal().master().applicationJava(a.id());
        return this.operations(javaApplication == null || javaApplication.operationList() == null ? List.of() : javaApplication.operationList());
    }

    private List<ObservableAssertion.Operation> operations(List<Observable.Operation> currentOperations) {
        ArrayList<ObservableAssertion.Operation> operations = new ArrayList<ObservableAssertion.Operation>(currentOperations.stream().map(this::assertionOf).toList());
        AppMonitorService.activityOperations().stream().filter(o -> currentOperations.stream().noneMatch(ao -> ao.activity().equals(o.activity()) && ao.name().equals(o.name()))).forEach(operations::add);
        return operations;
    }

    private ObservableAssertion.Operation assertionOf(Observable.Operation operation) {
        List procedures = operation.procedureList() == null ? Collections.emptyList() : this.procedures(operation);
        ObservableAssertion.Operation assertion = new ObservableAssertion.Operation().name(operation.name()).activity(operation.activity());
        if (procedures != null) {
            assertion.procedureList(procedures);
        }
        return assertion;
    }

    private List<ObservableAssertion.Operation.Procedure> procedures(Observable.Operation operation) {
        return operation.procedureList().stream().map(this::procedureOf).toList();
    }

    private ObservableAssertion.Operation.Procedure procedureOf(Observable.Operation.Procedure p) {
        ObservableAssertion.Operation.Procedure procedure = new ObservableAssertion.Operation.Procedure().name(p.name()).returnType(p.returnType()).description(p.description());
        if (p.parameterList() != null) {
            procedure.parameterList(this.map(p.parameterList()));
        }
        return procedure;
    }

    private List<ObservableAssertion.Operation.Procedure.Parameter> map(List<Observable.Operation.Procedure.Parameter> parameters) {
        return parameters.stream().map((? super T p) -> new ObservableAssertion.Operation.Procedure.Parameter().name(p.name()).type(p.type())).toList();
    }

    private List<Activity.System.OSProcess> osProcess(Integer pid) {
        Activity.System.OSProcess osProcess = this.processes.stream().filter(pr -> pr.processID() == pid.intValue()).findFirst().orElse(null);
        return osProcess == null ? List.of() : List.of(osProcess);
    }

    private static boolean isIn(List<? extends ApplicationJavaAssertion> ps, ApplicationAssertion p) {
        return ps.stream().anyMatch(jp -> new HashSet(jp.pids()).containsAll(p.pids()));
    }
}

