/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.monitoringactivity;

import com.google.gson.reflect.TypeToken;
import io.intino.alexandria.Json;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.scheduler.AlexandriaScheduler;
import io.intino.consul.framework.Activity;
import io.intino.consul.monitoringactivity.sentinels.RefreshAppsSentinel;
import io.intino.consul.monitoringactivity.sentinels.Sentinels;
import io.intino.consul.monitoringactivity.service.AppMonitorService;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.quartz.SchedulerException;

public class MonitoringActivity
implements Activity {
    public static final String APPLICATION_TAGS = "application-tags";
    public static final String ACTIVITY_ID = "monitoring-activity";
    private AlexandriaScheduler scheduler;
    private Activity.Context context;
    private Activity.Store store;
    private Map<String, String> applications;
    private AppMonitorService service;

    public String id() {
        return ACTIVITY_ID;
    }

    public Activity.Result configure(Activity.Context context, Activity.Store store) {
        this.context = context;
        this.store = store;
        this.applications = MonitoringActivity.applicationsFrom((String)context.initialConfiguration().get(APPLICATION_TAGS));
        this.scheduler = new AlexandriaScheduler(this.id());
        this.service = new AppMonitorService(this.id(), context, store, this.applications);
        new RefreshAppsSentinel().refreshApplications(context, this.applications);
        return new Activity.Result(true, "Activity configured successfully. Found " + this.applications.size() + " applications");
    }

    private static Map<String, String> applicationsFrom(String json) {
        if (json == null) {
            return new HashMap<String, String>();
        }
        List tags = (List)Json.fromJson((String)json, (Type)new TypeToken<List<Tag>>(){}.getType());
        return new ConcurrentHashMap<String, String>(tags.stream().collect(Collectors.toMap(t -> t.name, t -> t.tag)));
    }

    public Map<String, String> currentConfiguration() {
        return Map.of(APPLICATION_TAGS, Json.toJson(this.applications.entrySet().stream().map(e -> new Tag((String)e.getKey(), (String)e.getValue())).toList()));
    }

    public Activity.Result onStart() {
        Sentinels.init(this.id(), this.scheduler, this.context, this.store, this.applications);
        try {
            this.scheduler.startSchedules();
            this.service.start();
            return new Activity.Result(true, "Started successfully");
        }
        catch (SchedulerException e) {
            Logger.error((Throwable)e);
            return new Activity.Result(false, e.getMessage());
        }
    }

    public Activity.Result onStop() {
        try {
            if (this.scheduler != null) {
                this.scheduler.shutdownSchedules();
            }
            this.service.stop();
            return new Activity.Result(true, "Stopped successfully");
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return new Activity.Result(false, e.getMessage());
        }
    }

    public record Tag(String name, String tag) {
    }
}

