/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.version;

import java.util.ArrayList;
import java.util.Objects;
import org.eclipse.aether.util.version.GenericVersionConstraint;
import org.eclipse.aether.util.version.GenericVersionRange;
import org.eclipse.aether.util.version.UnionVersionRange;
import org.eclipse.aether.version.InvalidVersionSpecificationException;
import org.eclipse.aether.version.VersionScheme;

abstract class VersionSchemeSupport
implements VersionScheme {
    VersionSchemeSupport() {
    }

    @Override
    public GenericVersionRange parseVersionRange(String range) throws InvalidVersionSpecificationException {
        return new GenericVersionRange((VersionScheme)this, range);
    }

    @Override
    public GenericVersionConstraint parseVersionConstraint(String constraint) throws InvalidVersionSpecificationException {
        String process = Objects.requireNonNull(constraint, "constraint cannot be null");
        ArrayList<GenericVersionRange> ranges = new ArrayList<GenericVersionRange>();
        while (process.startsWith("[") || process.startsWith("(")) {
            int index2;
            int index1 = process.indexOf(41);
            int index = index2 = process.indexOf(93);
            if (index2 < 0 || index1 >= 0 && index1 < index2) {
                index = index1;
            }
            if (index < 0) {
                throw new InvalidVersionSpecificationException(constraint, "Unbounded version range " + constraint);
            }
            GenericVersionRange range = this.parseVersionRange(process.substring(0, index + 1));
            ranges.add(range);
            if (!(process = process.substring(index + 1).trim()).startsWith(",")) continue;
            process = process.substring(1).trim();
        }
        if (!process.isEmpty() && !ranges.isEmpty()) {
            throw new InvalidVersionSpecificationException(constraint, "Invalid version range " + constraint + ", expected [ or ( but got " + process);
        }
        GenericVersionConstraint result = ranges.isEmpty() ? new GenericVersionConstraint(this.parseVersion(constraint)) : new GenericVersionConstraint(UnionVersionRange.from(ranges));
        return result;
    }
}

