/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.javaoperationactivity.service.requests;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.framework.Activity;
import io.intino.consul.javaoperationactivity.box.schemas.Deploy;
import io.intino.consul.javaoperationactivity.box.schemas.Service;
import io.intino.consul.javaoperationactivity.operation.ServiceController;
import io.intino.consul.javaoperationactivity.service.JavaOperationService;
import io.intino.consul.terminal.RequestAttendant;
import jakarta.jms.JMSException;
import jakarta.jms.Message;
import java.io.File;
import java.io.IOException;
import java.net.Socket;
import java.time.Instant;
import java.util.List;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public class DeployApplicationRequest
implements RequestAttendant {
    public static final String ID = "deploy";
    private final Activity.Context context;
    private final Activity.Store store;
    private final ServiceController controller;
    private final File applicationsWorkspace;

    public DeployApplicationRequest(Activity.Context context, Activity.Store store) {
        this.context = context;
        this.store = store;
        this.controller = new ServiceController(context, store);
        this.applicationsWorkspace = new File((String)context.initialConfiguration().get("applications-workspace"));
    }

    public String id() {
        return ID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestAttendant.RequestResult responseTo(Message request) {
        Object object = JavaOperationService.monitor;
        synchronized (object) {
            Deploy deploySchema = this.deployInfo(request);
            if (deploySchema == null) {
                return new RequestAttendant.RequestResult(false, (Object)"Invalid deploy schema");
            }
            if (deploySchema.mainClass() == null) {
                return new RequestAttendant.RequestResult(false, (Object)"Invalid deploy schema. Main class required");
            }
            Service currentService = (Service)this.store.get(deploySchema.id(), Service.class);
            Logger.info((String)("Deploying " + deploySchema.artifact() + "..."));
            return this.deploy(currentService, deploySchema);
        }
    }

    private RequestAttendant.RequestResult deploy(Service currentService, Deploy deploySchema) {
        try {
            boolean wasRunning = this.stopIfRunning(currentService);
            Service newService = this.createService(currentService, deploySchema);
            RequestAttendant.RequestResult result = this.controller.deploy(newService);
            if (result.success()) {
                boolean start;
                this.store.put(newService.identifier(), (Object)newService);
                if (wasRunning && !(start = this.controller.start(newService.deployed(true)))) {
                    return new RequestAttendant.RequestResult(false, (Object)"Impossible to start process");
                }
                Logger.info((String)("Deployed " + deploySchema.id() + "!"));
            } else if (currentService != null) {
                this.restore(currentService);
            }
            return result;
        }
        catch (Throwable e) {
            Logger.error((Throwable)e);
            return new RequestAttendant.RequestResult(false, (Object)e.getMessage());
        }
    }

    private boolean stopIfRunning(Service currentService) throws Exception {
        boolean wasRunning = true;
        if (currentService != null) {
            wasRunning = this.controller.isRunning(currentService);
            this.controller.stop(currentService);
        }
        return wasRunning;
    }

    public boolean isAvailable(Message message) {
        return false;
    }

    private void restore(Service currentService) {
        RequestAttendant.RequestResult result = this.controller.deploy(currentService);
        if (result.success()) {
            this.store.put(currentService.identifier(), (Object)currentService.deployed(true));
        }
    }

    private Deploy deployInfo(Message request) {
        try {
            return (Deploy)this.parameter(request, ID, Deploy.class);
        }
        catch (JMSException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    private Service createService(Service currentService, Deploy deploySchema) {
        Service.Artifact artifact = this.artifact(deploySchema);
        Service service = new Service().identifier(deploySchema.id()).project(deploySchema.project()).artifact(artifact).shortName(artifact.artifactId()).workspace(new File(this.applicationsWorkspace, deploySchema.id().replace(":", "_")).getAbsolutePath()).managementPort(currentService != null ? currentService.managementPort() : this.newJMXPort()).debugPort(currentService != null ? currentService.debugPort() : this.newDebugPort()).creationTime(currentService != null ? currentService.creationTime() : Instant.now()).requirements(new Service.Requirements()).parameterList(this.parameters(deploySchema)).jvmParameters(DeployApplicationRequest.jvmParameters(deploySchema));
        if (deploySchema.requirements() != null) {
            if (deploySchema.requirements().minMemory() > 0) {
                service.requirements().minMemory(deploySchema.requirements().minMemory());
            }
            if (deploySchema.requirements().maxMemory() > 0) {
                service.requirements().maxMemory(deploySchema.requirements().maxMemory());
            }
        }
        return service;
    }

    private Service.Artifact artifact(Deploy deploy) {
        String[] id = deploy.artifact().split(":");
        Service.Artifact artifact = new Service.Artifact().identifier(deploy.artifact()).groupId(id[0]).artifactId(id[1]).version(id[2]).mainClass(deploy.mainClass());
        artifact.artifactoryList(deploy.artifactoryList().stream().map(DeployApplicationRequest::map).toList());
        if (deploy.classpathPrefix() != null) {
            artifact.classpathPrefix(deploy.classpathPrefix());
        }
        return artifact;
    }

    private static Service.Artifact.Artifactory map(Deploy.Artifactory a) {
        return new Service.Artifact.Artifactory().url(a.url()).snapshot(a.url().contains("snapshot")).mavenId(a.id()).user(a.user()).password(a.password());
    }

    private int newJMXPort() {
        List<Integer> usedPorts = this.services().map(Service::managementPort).toList();
        return IntStream.range(10001, 11000).filter(p -> !usedPorts.contains(p) && DeployApplicationRequest.available(p)).findFirst().orElse(11000);
    }

    private static List<String> jvmParameters(Deploy deploySchema) {
        return deploySchema.jVMParameterList().stream().map(Deploy.JVMParameter::value).toList();
    }

    private int newDebugPort() {
        List<Integer> usedPorts = this.services().map(Service::debugPort).toList();
        return IntStream.range(6000, 6100).filter(p -> !usedPorts.contains(p) && DeployApplicationRequest.available(p)).findFirst().orElse(6100);
    }

    public static boolean available(int port) {
        boolean bl;
        Socket ignored = new Socket("localhost", port);
        try {
            bl = false;
        }
        catch (Throwable throwable) {
            try {
                try {
                    ignored.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ignored2) {
                return true;
            }
        }
        ignored.close();
        return bl;
    }

    private List<Service.Parameter> parameters(Deploy deploySchema) {
        return deploySchema.parameterList().stream().map(parameter -> new Service.Parameter().name(parameter.name()).value(parameter.value())).toList();
    }

    private Stream<Service> services() {
        return this.store.keys().map(k -> (Service)this.store.get(k, Service.class));
    }
}

