/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.javaoperationactivity.operation.deploy;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.SettingsUtils;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingResult;

public class MavenSettings {
    public static Settings settings() {
        SettingsBuildingResult result;
        DefaultSettingsBuilder builder = new DefaultSettingsBuilderFactory().newInstance();
        DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
        String user = System.getProperty("org.apache.maven.user-settings");
        if (user == null) {
            request.setUserSettingsFile(new File(new File(System.getProperty("user.home")).getAbsoluteFile(), "/.m2/settings.xml"));
        } else {
            request.setUserSettingsFile(new File(user));
        }
        String global = System.getProperty("org.apache.maven.global-settings");
        if (global != null) {
            request.setGlobalSettingsFile(new File(global));
        }
        try {
            result = builder.build(request);
        }
        catch (SettingsBuildingException ex) {
            throw new IllegalStateException(ex);
        }
        return MavenSettings.invokers(builder, result);
    }

    static Settings invokers(SettingsBuilder builder, SettingsBuildingResult result) {
        Settings main = result.getEffectiveSettings();
        Path path = Paths.get(System.getProperty("user.dir"), "..", "interpolated-settings.xml");
        if (Files.exists(path, new LinkOption[0])) {
            DefaultSettingsBuildingRequest irequest = new DefaultSettingsBuildingRequest();
            irequest.setUserSettingsFile(path.toAbsolutePath().toFile());
            try {
                Settings isettings = builder.build(irequest).getEffectiveSettings();
                SettingsUtils.merge(isettings, main, "user-level");
                main = isettings;
            }
            catch (SettingsBuildingException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return main;
    }
}

