/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.javaoperationactivity.operation.deploy;

import java.io.File;
import java.util.Collections;
import java.util.List;
import org.apache.maven.repository.internal.MavenRepositorySystemUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.connector.basic.BasicRepositoryConnectorFactory;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.impl.DefaultServiceLocator;
import org.eclipse.aether.metadata.DefaultMetadata;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.resolution.MetadataRequest;
import org.eclipse.aether.resolution.MetadataResult;
import org.eclipse.aether.spi.connector.RepositoryConnectorFactory;
import org.eclipse.aether.spi.connector.transport.TransporterFactory;
import org.eclipse.aether.transport.classpath.ClasspathTransporterFactory;
import org.eclipse.aether.transport.file.FileTransporterFactory;
import org.eclipse.aether.transport.http.HttpTransporterFactory;
import org.eclipse.aether.util.repository.SimpleArtifactDescriptorPolicy;
import org.eclipse.aether.util.repository.SimpleResolutionErrorPolicy;

public class LibraryResolver {
    private RepositorySystem system;
    private static final String DEFAULT_REPO_LOCAL = String.format("%s/.m2/repository", System.getProperty("user.home"));
    private static final RemoteRepository DEFAULT_REPO_REMOTE = new RemoteRepository.Builder("central", "default", "https://repo1.maven.org/maven2/").build();
    private RepositorySystemSession session;
    private final List<RemoteRepository> remoteRepos;

    private void loadService() {
        DefaultServiceLocator locator = MavenRepositorySystemUtils.newServiceLocator();
        locator.addService(RepositoryConnectorFactory.class, BasicRepositoryConnectorFactory.class);
        locator.addService(TransporterFactory.class, FileTransporterFactory.class);
        locator.addService(TransporterFactory.class, HttpTransporterFactory.class);
        locator.addService(TransporterFactory.class, ClasspathTransporterFactory.class);
        this.system = locator.getService(RepositorySystem.class);
    }

    private void init() {
        this.init(DEFAULT_REPO_LOCAL);
    }

    private void init(String localRepo) {
        if (this.system == null) {
            this.loadService();
        }
        if (this.session == null) {
            this.session = this.buildSession(localRepo);
        }
    }

    public void resetSession() {
        File basedir = this.session.getLocalRepository().getBasedir();
        this.session = null;
        this.init(basedir.getAbsolutePath());
    }

    void removeResolutionFromSession(String[] coors) {
        this.session.getCache().put(this.session, coors, null);
    }

    public LibraryResolver(File localRepository, List<RemoteRepository> remoteRepos) {
        this(localRepository.getAbsolutePath(), remoteRepos);
    }

    public LibraryResolver(String localRepository, List<RemoteRepository> remoteRepos) {
        this.loadService();
        this.init(localRepository);
        this.remoteRepos = remoteRepos.isEmpty() ? List.of(DEFAULT_REPO_REMOTE) : remoteRepos;
    }

    public MetadataResult metadata(DefaultArtifact artifact) {
        return this.system.resolveMetadata(this.session, Collections.singleton(new MetadataRequest(new DefaultMetadata(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getClassifier(), Metadata.Nature.RELEASE_OR_SNAPSHOT)))).get(0);
    }

    public ArtifactResult resolveSources(Artifact dependency) {
        try {
            return this.system.resolveArtifact(this.session, new ArtifactRequest(dependency, this.remoteRepos, null));
        }
        catch (ArtifactResolutionException e) {
            return e.getResult();
        }
    }

    public DependencyResult resolve(DefaultArtifact artifact, String scope) throws DependencyResolutionException {
        return this.system.resolveDependencies(this.session, this.request(artifact, scope));
    }

    private DependencyRequest request(DefaultArtifact artifact, String scope) {
        return new DependencyRequest(new CollectRequest(List.of(new Dependency(artifact, scope.toLowerCase())), null, this.remoteRepos), null);
    }

    private RepositorySystemSession buildSession(String localRepo) {
        DefaultRepositorySystemSession session = MavenRepositorySystemUtils.newSession();
        return session.setLocalRepositoryManager(this.system.newLocalRepositoryManager(session, new LocalRepository(localRepo))).setUpdatePolicy("always").setChecksumPolicy("fail").setArtifactDescriptorPolicy(new SimpleArtifactDescriptorPolicy(false, false)).setConfigProperty("aether.connector.requestTimeout", 20000).setResolutionErrorPolicy(new SimpleResolutionErrorPolicy(0, 0));
    }
}

