/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.util.repository;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.LocalArtifactRegistration;
import org.eclipse.aether.repository.LocalArtifactRequest;
import org.eclipse.aether.repository.LocalArtifactResult;
import org.eclipse.aether.repository.LocalMetadataRegistration;
import org.eclipse.aether.repository.LocalMetadataRequest;
import org.eclipse.aether.repository.LocalMetadataResult;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.LocalRepositoryManager;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.util.ConfigUtils;

public final class ChainedLocalRepositoryManager
implements LocalRepositoryManager {
    private static final String CONFIG_PROPS_PREFIX = "aether.chainedLocalRepository.";
    public static final String CONFIG_PROP_IGNORE_TAIL_AVAILABILITY = "aether.chainedLocalRepository.ignoreTailAvailability";
    public static final boolean DEFAULT_IGNORE_TAIL_AVAILABILITY = true;
    private final LocalRepositoryManager head;
    private final List<LocalRepositoryManager> tail;
    private final boolean ignoreTailAvailability;

    public ChainedLocalRepositoryManager(LocalRepositoryManager head, List<LocalRepositoryManager> tail, boolean ignoreTailAvailability) {
        this.head = Objects.requireNonNull(head, "head cannot be null");
        this.tail = Objects.requireNonNull(tail, "tail cannot be null");
        this.ignoreTailAvailability = ignoreTailAvailability;
    }

    public ChainedLocalRepositoryManager(LocalRepositoryManager head, List<LocalRepositoryManager> tail, RepositorySystemSession session) {
        this.head = Objects.requireNonNull(head, "head cannot be null");
        this.tail = Objects.requireNonNull(tail, "tail cannot be null");
        this.ignoreTailAvailability = ConfigUtils.getBoolean(session, true, CONFIG_PROP_IGNORE_TAIL_AVAILABILITY);
    }

    @Override
    public LocalRepository getRepository() {
        return this.head.getRepository();
    }

    @Override
    public String getPathForLocalArtifact(Artifact artifact) {
        return this.head.getPathForLocalArtifact(artifact);
    }

    @Override
    public String getPathForRemoteArtifact(Artifact artifact, RemoteRepository repository, String context) {
        return this.head.getPathForRemoteArtifact(artifact, repository, context);
    }

    @Override
    public String getPathForLocalMetadata(Metadata metadata) {
        return this.head.getPathForLocalMetadata(metadata);
    }

    @Override
    public String getPathForRemoteMetadata(Metadata metadata, RemoteRepository repository, String context) {
        return this.head.getPathForRemoteMetadata(metadata, repository, context);
    }

    @Override
    public LocalArtifactResult find(RepositorySystemSession session, LocalArtifactRequest request) {
        LocalArtifactResult result = this.head.find(session, request);
        if (result.isAvailable()) {
            return result;
        }
        for (LocalRepositoryManager lrm : this.tail) {
            result = lrm.find(session, request);
            if (result.getPath() == null) continue;
            if (this.ignoreTailAvailability) {
                result.setAvailable(true);
                return result;
            }
            if (!result.isAvailable()) continue;
            return result;
        }
        return new LocalArtifactResult(request);
    }

    @Override
    public void add(RepositorySystemSession session, LocalArtifactRegistration request) {
        String artifactPath = request.getRepository() != null ? this.getPathForRemoteArtifact(request.getArtifact(), request.getRepository(), "check") : this.getPathForLocalArtifact(request.getArtifact());
        Path file = this.head.getRepository().getBasePath().resolve(artifactPath);
        if (Files.isRegularFile(file, new LinkOption[0])) {
            this.head.add(session, request);
        }
    }

    @Override
    public LocalMetadataResult find(RepositorySystemSession session, LocalMetadataRequest request) {
        LocalMetadataResult result = this.head.find(session, request);
        if (result.getPath() != null) {
            return result;
        }
        for (LocalRepositoryManager lrm : this.tail) {
            result = lrm.find(session, request);
            if (result.getPath() == null) continue;
            return result;
        }
        return new LocalMetadataResult(request);
    }

    @Override
    public void add(RepositorySystemSession session, LocalMetadataRegistration request) {
        String metadataPath = request.getRepository() != null ? this.getPathForRemoteMetadata(request.getMetadata(), request.getRepository(), "check") : this.getPathForLocalMetadata(request.getMetadata());
        Path file = this.head.getRepository().getBasePath().resolve(metadataPath);
        if (Files.isRegularFile(file, new LinkOption[0])) {
            this.head.add(session, request);
        }
    }

    public String toString() {
        return this.head.getRepository().toString() + this.tail.stream().map(LocalRepositoryManager::getRepository).collect(Collectors.toList());
    }
}

