/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.lifecycle.internal;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.lifecycle.MojoExecutionConfigurator;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.PluginExecution;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.Parameter;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.MessageUtils;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=MojoExecutionConfigurator.class)
public class DefaultMojoExecutionConfigurator
implements MojoExecutionConfigurator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public void configure(MavenProject project, MojoExecution mojoExecution, boolean allowPluginLevelConfig) {
        String a;
        String g = mojoExecution.getPlugin().getGroupId();
        Plugin plugin = this.findPlugin(g, a = mojoExecution.getPlugin().getArtifactId(), project.getBuildPlugins());
        if (plugin == null && project.getPluginManagement() != null) {
            plugin = this.findPlugin(g, a, project.getPluginManagement().getPlugins());
        }
        if (plugin != null) {
            PluginExecution pluginExecution = this.findPluginExecution(mojoExecution.getExecutionId(), plugin.getExecutions());
            Xpp3Dom pomConfiguration = null;
            if (pluginExecution != null) {
                pomConfiguration = (Xpp3Dom)pluginExecution.getConfiguration();
            } else if (allowPluginLevelConfig) {
                pomConfiguration = (Xpp3Dom)plugin.getConfiguration();
            }
            Xpp3Dom mojoConfiguration = pomConfiguration != null ? new Xpp3Dom(pomConfiguration) : null;
            mojoConfiguration = Xpp3Dom.mergeXpp3Dom(mojoExecution.getConfiguration(), mojoConfiguration);
            mojoExecution.setConfiguration(mojoConfiguration);
            this.checkUnknownMojoConfigurationParameters(mojoExecution);
        }
    }

    private Plugin findPlugin(String groupId, String artifactId, Collection<Plugin> plugins) {
        for (Plugin plugin : plugins) {
            if (!artifactId.equals(plugin.getArtifactId()) || !groupId.equals(plugin.getGroupId())) continue;
            return plugin;
        }
        return null;
    }

    private PluginExecution findPluginExecution(String executionId, Collection<PluginExecution> executions) {
        if (StringUtils.isNotEmpty(executionId)) {
            for (PluginExecution execution : executions) {
                if (!executionId.equals(execution.getId())) continue;
                return execution;
            }
        }
        return null;
    }

    private void checkUnknownMojoConfigurationParameters(MojoExecution mojoExecution) {
        if (mojoExecution.getMojoDescriptor() == null || mojoExecution.getConfiguration() == null || mojoExecution.getConfiguration().getChildCount() == 0) {
            return;
        }
        MojoDescriptor mojoDescriptor = mojoExecution.getMojoDescriptor();
        Set<String> parametersNamesGoal = Optional.ofNullable(mojoDescriptor.getParameters()).orElseGet(Collections::emptyList).stream().flatMap(this::getParameterNames).collect(Collectors.toSet());
        Set<String> unknownParameters = this.getUnknownParameters(mojoExecution, parametersNamesGoal);
        if (unknownParameters.isEmpty()) {
            return;
        }
        Set<String> parametersNamesAll = Optional.ofNullable(mojoDescriptor.getPluginDescriptor()).map(PluginDescriptor::getMojos).orElseGet(Collections::emptyList).stream().filter(m -> m.getParameters() != null).flatMap(m -> m.getParameters().stream()).flatMap(this::getParameterNames).collect(Collectors.toSet());
        unknownParameters = this.getUnknownParameters(mojoExecution, parametersNamesAll);
        unknownParameters.stream().filter(parameterName -> this.isNotReportPluginsForMavenSite((String)parameterName, mojoExecution)).forEach(name -> {
            MessageBuilder messageBuilder = MessageUtils.buffer().warning("Parameter '").warning(name).warning("' is unknown for plugin '").warning(mojoExecution.getArtifactId()).warning(":").warning(mojoExecution.getVersion()).warning(":").warning(mojoExecution.getGoal());
            if (mojoExecution.getExecutionId() != null) {
                messageBuilder.warning(" (");
                messageBuilder.warning(mojoExecution.getExecutionId());
                messageBuilder.warning(")");
            }
            messageBuilder.warning("'");
            this.logger.warn(messageBuilder.toString());
        });
    }

    private boolean isNotReportPluginsForMavenSite(String parameterName, MojoExecution mojoExecution) {
        return !"reportPlugins".equals(parameterName) || !"maven-site-plugin".equals(mojoExecution.getArtifactId());
    }

    private Stream<String> getParameterNames(Parameter parameter) {
        if (parameter.getAlias() != null) {
            return Stream.of(parameter.getName(), parameter.getAlias());
        }
        return Stream.of(parameter.getName());
    }

    private Set<String> getUnknownParameters(MojoExecution mojoExecution, Set<String> parameters) {
        return Arrays.stream(mojoExecution.getConfiguration().getChildren()).map(Xpp3Dom::getName).filter(name -> !parameters.contains(name)).collect(Collectors.toSet());
    }
}

