/*
 * Decompiled with CFR 0.152.
 */
package io.intino.itrules.template.condition.predicates;

import io.intino.itrules.template.condition.BinaryExpression;
import io.intino.itrules.template.condition.BinaryOperator;
import io.intino.itrules.template.condition.LogicalExpression;
import io.intino.itrules.template.condition.NotExpression;
import io.intino.itrules.template.condition.Predicate;
import io.intino.itrules.template.condition.predicates.AttributePredicate;
import io.intino.itrules.template.condition.predicates.TriggerPredicate;
import io.intino.itrules.template.condition.predicates.TypePredicate;

public class Predicates {
    public static Predicate not(LogicalExpression expression) {
        return new NotExpression(expression);
    }

    public static Predicate attribute(String attribute) {
        return new AttributePredicate(attribute);
    }

    public static Predicate attribute(String attribute, Object value) {
        return new AttributePredicate(attribute, value);
    }

    public static Predicate type(String type) {
        return new TypePredicate(type);
    }

    public static Predicate allTypes(String ... types) {
        return new TypePredicate(types);
    }

    public static Predicate trigger(String name) {
        return new TriggerPredicate(name);
    }

    public static BinaryExpression all(LogicalExpression left, LogicalExpression right) {
        return new BinaryExpression(left, BinaryOperator.AND, right);
    }

    public static LogicalExpression all(LogicalExpression ... expressions) {
        LogicalExpression root = expressions[0];
        if (expressions.length == 1) {
            return root;
        }
        for (int i = 0; i < expressions.length - 1; ++i) {
            root = new BinaryExpression(root, BinaryOperator.AND, expressions[i + 1]);
        }
        return root;
    }

    public static BinaryExpression any(LogicalExpression left, LogicalExpression right) {
        return new BinaryExpression(left, BinaryOperator.OR, right);
    }

    public static LogicalExpression any(LogicalExpression ... expressions) {
        LogicalExpression root = expressions[0];
        if (expressions.length == 1) {
            return root;
        }
        for (int i = 0; i < expressions.length - 1; ++i) {
            root = new BinaryExpression(root, BinaryOperator.OR, expressions[i + 1]);
        }
        return root;
    }
}

