/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.aether;

import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.ListIterator;
import java.util.Objects;
import org.apache.maven.model.InputLocation;
import org.apache.maven.model.Plugin;
import org.eclipse.aether.AbstractRepositoryListener;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.collection.CollectStepData;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;

class ReverseTreeRepositoryListener
extends AbstractRepositoryListener {
    ReverseTreeRepositoryListener() {
    }

    @Override
    public void artifactResolved(RepositoryEvent event) {
        String baseName;
        Path trackingDir;
        boolean missing;
        Objects.requireNonNull(event, "event cannot be null");
        if (!ReverseTreeRepositoryListener.isLocalRepositoryArtifactOrMissing(event.getSession(), event.getArtifact())) {
            return;
        }
        CollectStepData collectStepTrace = null;
        ArtifactRequest artifactRequest = null;
        ArtifactDescriptorRequest artifactDescriptorRequest = null;
        Plugin plugin = null;
        for (RequestTrace trace = event.getTrace(); trace != null; trace = trace.getParent()) {
            Object data = trace.getData();
            if (data instanceof CollectStepData) {
                collectStepTrace = (CollectStepData)data;
                continue;
            }
            if (data instanceof ArtifactDescriptorRequest) {
                artifactDescriptorRequest = (ArtifactDescriptorRequest)data;
                continue;
            }
            if (data instanceof ArtifactRequest) {
                artifactRequest = (ArtifactRequest)data;
                continue;
            }
            if (!(data instanceof Plugin)) continue;
            plugin = (Plugin)data;
        }
        boolean bl = missing = event.getFile() == null;
        if (missing) {
            File dir = event.getSession().getLocalRepository().getBasedir();
            dir = new File(dir, event.getSession().getLocalRepositoryManager().getPathForLocalArtifact(event.getArtifact()));
            trackingDir = dir.getParentFile().toPath().resolve(".tracking");
        } else {
            trackingDir = event.getFile().getParentFile().toPath().resolve(".tracking");
        }
        String ext = missing ? ".miss" : ".dep";
        Path trackingFile = null;
        String indent = "";
        ArrayList<String> trackingData = new ArrayList<String>();
        if (collectStepTrace == null && plugin != null) {
            ext = ".plugin";
            baseName = plugin.getGroupId() + "_" + plugin.getArtifactId() + "_" + plugin.getVersion();
            trackingFile = trackingDir.resolve(baseName + ext);
            if (Files.exists(trackingFile, new LinkOption[0])) {
                return;
            }
            if (event.getArtifact() != null) {
                trackingData.add(indent + event.getArtifact());
                indent = indent + "  ";
            }
            trackingData.add(indent + plugin.getGroupId() + ":" + plugin.getArtifactId() + ":" + plugin.getVersion());
            indent = indent + "  ";
            InputLocation location = plugin.getLocation("");
            if (location != null && location.getSource() != null) {
                trackingData.add(indent + location.getSource().getModelId() + " (implicit)");
                indent = indent + "  ";
            }
        } else if (collectStepTrace != null) {
            Artifact nodeArtifact;
            if (collectStepTrace.getPath().get(0).getArtifact() == null) {
                return;
            }
            baseName = ArtifactIdUtils.toId(collectStepTrace.getPath().get(0).getArtifact()).replace(":", "_");
            trackingFile = trackingDir.resolve(baseName + ext);
            if (Files.exists(trackingFile, new LinkOption[0])) {
                return;
            }
            Artifact resolvedArtifact = event.getArtifact();
            if (ReverseTreeRepositoryListener.isInScope(resolvedArtifact, nodeArtifact = collectStepTrace.getNode().getArtifact()) || "pom".equals(resolvedArtifact.getExtension())) {
                Dependency node = collectStepTrace.getNode();
                trackingData.add(resolvedArtifact.toString());
                indent = indent + "  ";
                trackingData.add(indent + node + " (" + collectStepTrace.getContext() + ")");
                ListIterator<DependencyNode> iter = collectStepTrace.getPath().listIterator(collectStepTrace.getPath().size());
                while (iter.hasPrevious()) {
                    DependencyNode curr = iter.previous();
                    indent = indent + "  ";
                    trackingData.add(indent + curr + " (" + collectStepTrace.getContext() + ")");
                }
            }
        }
        if (trackingFile == null) {
            return;
        }
        try {
            Files.createDirectories(trackingDir, new FileAttribute[0]);
            trackingData.add("");
            if (!missing) {
                if (event.getRepository() != null) {
                    trackingData.add("Repository: " + event.getRepository());
                }
            } else {
                ArrayList<RemoteRepository> repositories = new ArrayList<RemoteRepository>();
                if (artifactRequest != null && artifactRequest.getRepositories() != null) {
                    repositories.addAll(artifactRequest.getRepositories());
                } else if (artifactDescriptorRequest != null && artifactDescriptorRequest.getRepositories() != null) {
                    repositories.addAll(artifactDescriptorRequest.getRepositories());
                }
                if (!repositories.isEmpty()) {
                    trackingData.add("Configured repositories:");
                    for (RemoteRepository r : repositories) {
                        trackingData.add(" - " + r.getId() + " : " + r.getUrl());
                    }
                } else {
                    trackingData.add("No repositories configured");
                }
            }
            Files.write(trackingFile, trackingData, StandardCharsets.UTF_8, new OpenOption[0]);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static boolean isLocalRepositoryArtifactOrMissing(RepositorySystemSession session, Artifact artifact) {
        return artifact.getFile() == null || artifact.getFile().getPath().startsWith(session.getLocalRepository().getBasedir().getPath());
    }

    static CollectStepData lookupCollectStepData(RequestTrace trace) {
        CollectStepData collectStepTrace = null;
        while (trace != null) {
            if (trace.getData() instanceof CollectStepData) {
                collectStepTrace = (CollectStepData)trace.getData();
                break;
            }
            trace = trace.getParent();
        }
        return collectStepTrace;
    }

    static boolean isInScope(Artifact artifact, Artifact nodeArtifact) {
        return Objects.equals(artifact.getGroupId(), nodeArtifact.getGroupId()) && Objects.equals(artifact.getArtifactId(), nodeArtifact.getArtifactId()) && Objects.equals(artifact.getVersion(), nodeArtifact.getVersion());
    }
}

