/*
 * Decompiled with CFR 0.152.
 */
package io.intino.itrules;

import io.intino.itrules.Adapter;
import io.intino.itrules.Formatter;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import io.intino.itrules.Trigger;
import io.intino.itrules.formatters.DateFormatters;
import io.intino.itrules.formatters.NumberFormatters;
import io.intino.itrules.formatters.StringFormatters;
import io.intino.itrules.template.Output;
import io.intino.itrules.template.Rule;
import io.intino.itrules.template.Template;
import io.intino.itrules.template.outputs.Expression;
import io.intino.itrules.template.outputs.Literal;
import io.intino.itrules.template.outputs.Placeholder;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Engine {
    private static final String Blanks = " \u00a0\t\n";
    private static final String NewLine = "\n";
    private final Iterable<Rule> ruleSet;
    private final Template.Configuration configuration;
    private final Map<String, Formatter> formatters;
    private final Map<Class<?>, Adapter> adapters;

    public Engine(Template template) {
        this(template.ruleSet(), template.configuration());
    }

    public Engine(Iterable<Rule> ruleSet) {
        this(ruleSet, new Template.Configuration());
    }

    public Engine(Iterable<Rule> ruleSet, Template.Configuration configuration) {
        this.ruleSet = ruleSet;
        this.configuration = configuration;
        this.formatters = this.formattersFor(configuration);
        this.adapters = new HashMap();
    }

    public Engine add(String name, Formatter formatter) {
        this.formatters.put(name.toLowerCase(), formatter);
        return this;
    }

    public Engine addAll(Map<String, Formatter> formatters) {
        formatters.forEach((k, v) -> this.add((String)k, (Formatter)v));
        return this;
    }

    public <T> Engine add(Class<T> class_, Adapter<T> adapter) {
        this.adapters.put(class_, adapter);
        return this;
    }

    public String render(Object object) {
        return this.generate(new Trigger("root").on(this.frameOf(object)));
    }

    private String generate(Trigger trigger) {
        return this.write(new Display(trigger).generate());
    }

    private String write(Canvas canvas) {
        return canvas.contentWith(this.configuration);
    }

    private Frame frameOf(Object object) {
        if (object instanceof Frame) {
            return (Frame)object;
        }
        if (object instanceof FrameBuilder) {
            return ((FrameBuilder)object).toFrame();
        }
        return new FrameBuilder().put(this.adapters).append(object).toFrame();
    }

    private Map<String, Formatter> formattersFor(Template.Configuration configuration) {
        HashMap<String, Formatter> map = new HashMap<String, Formatter>();
        map.putAll(StringFormatters.get(configuration.locale()));
        map.putAll(NumberFormatters.get(configuration.locale()));
        map.putAll(DateFormatters.get(configuration.locale()));
        return map;
    }

    static Frame resolve(Frame frame, String[] path) {
        if (path == null || path.length == 0) {
            return frame;
        }
        Frame current = frame;
        for (String step : path) {
            if (step.equalsIgnoreCase("container")) {
                current = current.container();
                continue;
            }
            if (step.equalsIgnoreCase("root")) {
                current = Engine.root(current);
                continue;
            }
            Iterator<Frame> frames = frame.frames(step.toLowerCase());
            if (frames.hasNext()) {
                current = frames.next();
                continue;
            }
            return frame;
        }
        return current;
    }

    private static Frame root(Frame frame) {
        Frame current;
        for (current = frame; current != null; current = current.container()) {
            if (current.container() != null) continue;
            return current;
        }
        return current;
    }

    private static boolean isBlank(char c) {
        return Blanks.indexOf(c) >= 0;
    }

    private class Display {
        private final Trigger trigger;
        private final Canvas canvas;

        Display(Trigger trigger) {
            this.trigger = trigger;
            this.canvas = new Canvas();
        }

        private Display set(boolean constant) {
            if (constant) {
                this.canvas.touch();
            }
            return this;
        }

        Canvas generate() {
            return this.generate(this.ruleFor(this.trigger).outputs());
        }

        private Canvas generate(Stream<Output> outputs) {
            outputs.forEach(this::write);
            return this.canvas;
        }

        private Rule ruleFor(Trigger trigger) {
            for (Rule rule : Engine.this.ruleSet) {
                if (!rule.condition().evaluate(trigger)) continue;
                return rule;
            }
            return this.defaultRule(trigger.frame());
        }

        private Rule defaultRule(Frame frame) {
            return this.hasValue(frame) ? new Rule().output(Placeholder.This) : new Rule().output(new Output[0]);
        }

        private void write(Output output) {
            if (output instanceof Literal) {
                this.write((Literal)output);
            }
            if (output instanceof Placeholder) {
                this.write((Placeholder)output);
            }
            if (output instanceof Expression) {
                this.write((Expression)output);
            }
        }

        private void write(Literal literal) {
            this.append(this.canvas, literal.toString());
        }

        private void write(Placeholder placeholder) {
            this.append(this.canvas, placeholder.isThis() ? this.evaluateThis(this.trigger.frame(), placeholder.formatters()) : this.evaluate(placeholder));
        }

        private void write(Expression expression) {
            Canvas o = this.evaluate(expression);
            if (o.isNotTouched() || o.isEmpty()) {
                this.canvas.backSpaces();
            }
            this.append(this.canvas, o);
        }

        private Canvas evaluateThis(Frame frame, String[] formatters) {
            return this.hasValue(frame) ? this.evaluateThis(this.format(frame, formatters)) : new Canvas();
        }

        private Frame format(Frame frame, String[] formatters) {
            if (formatters.length == 0) {
                return frame;
            }
            Object object = frame.value() != null ? frame.value() : frame;
            for (String name : formatters) {
                object = this.formatter(name).format(object);
            }
            return Engine.this.frameOf(object);
        }

        private Formatter formatter(String name) {
            name = name.trim().toLowerCase();
            return Engine.this.formatters.getOrDefault(name, Formatter.Null);
        }

        private Canvas evaluateThis(Frame frame) {
            return new Canvas().append(this.valueOf(frame)).touch();
        }

        private Canvas evaluate(Placeholder placeholder) {
            return this.hasContent(placeholder) ? this.evaluate(placeholder, this.trigger.frames(placeholder)) : new Canvas();
        }

        private Canvas evaluate(Placeholder placeholder, Iterator<Frame> frames) {
            Canvas canvas = new Canvas();
            while (frames.hasNext()) {
                Frame frame = frames.next();
                this.append(canvas, this.evaluate(placeholder, frame), placeholder.separator());
            }
            return canvas;
        }

        private Canvas evaluate(Placeholder placeholder, Frame frame) {
            Canvas canvas = new Display(new Trigger(placeholder.fullName()).on(this.format(frame, placeholder.formatters()))).generate();
            if (canvas.isNotEmpty()) {
                canvas.touch();
            }
            return canvas;
        }

        private boolean hasValue(Frame frame) {
            return frame.value() != null;
        }

        private boolean hasContent(Placeholder placeholder) {
            Frame frame = Engine.resolve(this.trigger.frame(), placeholder.targetPath());
            return frame.frames(placeholder.name()).hasNext();
        }

        private Canvas evaluate(Expression expression) {
            Canvas canvas = new Display(this.trigger).set(expression.isConstant()).generate(expression.outputs());
            return canvas.isTouched() ? canvas.stake() : this.validate(expression.next());
        }

        private Canvas validate(Expression expression) {
            return expression != null ? this.evaluate(expression) : new Canvas();
        }

        private void append(Canvas canvas, String str) {
            canvas.append(str);
        }

        private void append(Canvas canvas, Canvas o, String separator) {
            if (o.isNotTouched()) {
                return;
            }
            if (canvas.isNotEmpty()) {
                canvas.append(separator);
            }
            canvas.append(o.toString()).touch();
        }

        private void append(Canvas canvas, Canvas o) {
            if (o.isNotTouched()) {
                return;
            }
            canvas.append(this.indent(o.toString())).touch();
        }

        private String valueOf(Frame frame) {
            return frame.value().toString();
        }

        private String indent(String str) {
            return this.canvas.hasNewLines() ? this.replaceNewLines(str) : str;
        }

        private String replaceNewLines(String str) {
            return str.replace(Engine.NewLine, Engine.NewLine + this.indentOf(this.canvas.toString()));
        }

        private String indentOf(String str) {
            return this.onlyBlanks(str.substring(this.lastNewLine(str) + 1));
        }

        private int lastNewLine(String str) {
            return str.lastIndexOf(Engine.NewLine);
        }

        private String onlyBlanks(String str) {
            int first;
            int last;
            if (str.isEmpty()) {
                return "";
            }
            for (last = first = str.charAt(0) == '\uffff' ? 1 : 0; last < str.length() && Engine.isBlank(str.charAt(last)); ++last) {
            }
            return str.substring(first, last);
        }
    }

    private static class Canvas {
        private final StringBuilder sb = new StringBuilder();
        private boolean touched = false;

        Canvas append(String s) {
            this.sb.append(s);
            return this;
        }

        String contentWith(Template.Configuration configuration) {
            return this.clean(this.withoutStakes(this.sb).toString()).collect(Collectors.joining(configuration.isCRLF() ? "\r\n" : Engine.NewLine));
        }

        private Stream<String> clean(String str) {
            return this.clean(str.split(Engine.NewLine));
        }

        private Stream<String> clean(String[] lines) {
            return Arrays.stream(lines).map(this::cleanLine);
        }

        private String cleanLine(String line) {
            return line.replaceAll("^\\s*$", "");
        }

        Canvas touch() {
            this.touched = true;
            return this;
        }

        boolean isTouched() {
            return this.touched;
        }

        boolean isNotTouched() {
            return !this.isTouched();
        }

        Canvas stake() {
            this.sb.appendCodePoint(65535);
            return this;
        }

        private StringBuilder withoutStakes(StringBuilder sb) {
            return sb.codePoints().filter(c -> c != 65535).collect(StringBuilder::new, StringBuilder::appendCodePoint, StringBuilder::append);
        }

        public boolean isEmpty() {
            return this.sb.isEmpty();
        }

        public boolean isNotEmpty() {
            return !this.sb.isEmpty();
        }

        private void backSpaces() {
            int index;
            for (index = this.sb.length() - 1; index >= 0 && Engine.isBlank(this.sb.charAt(index)); --index) {
            }
            this.sb.delete(index + 1, this.sb.length());
        }

        public boolean hasNewLines() {
            return this.sb.indexOf(Engine.NewLine) >= 0;
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

