/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.javaoperationactivity.sentinels;

import io.intino.alexandria.event.Event;
import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.scheduler.ScheduledTrigger;
import io.intino.consul.framework.Activity;
import io.intino.consul.javaoperationactivity.box.schemas.Service;
import io.intino.consul.javaoperationactivity.operation.JavaApplicationConnector;
import io.intino.consul.javaoperationactivity.operation.ServiceController;
import io.intino.consul.javaoperationactivity.service.JavaOperationService;
import io.intino.cosmos.datahub.datamarts.master.entities.ApplicationJava;
import io.intino.cosmos.datahub.datamarts.master.entities.Observable;
import io.intino.cosmos.datahub.messages.universe.ApplicationJavaAssertion;
import io.intino.cosmos.datahub.messages.universe.ObservableAssertion;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.quartz.JobExecutionContext;

public class ScheduleRefreshOperationsSentinel
implements ScheduledTrigger {
    public void execute(JobExecutionContext context) {
        try {
            new RefreshOperationsAction((Activity.Context)context.getMergedJobDataMap().get((Object)"context"), (Activity.Store)context.getMergedJobDataMap().get((Object)"store")).execute();
        }
        catch (Exception e) {
            Logger.error((String)e.getMessage());
        }
    }

    public static class RefreshOperationsAction {
        private final Activity.Context context;
        private final Activity.Store store;
        private final ServiceController controller;

        public RefreshOperationsAction(Activity.Context context, Activity.Store store) {
            this.context = context;
            this.store = store;
            this.controller = new ServiceController(context, store);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void execute() {
            Object object = JavaOperationService.monitor;
            synchronized (object) {
                try {
                    this.store.keys().forEach(k -> this.updatedObservable((Service)this.store.get(k, Service.class)));
                }
                catch (Throwable e) {
                    Logger.error((String)e.getMessage());
                }
            }
        }

        private void updatedObservable(Service service) {
            try {
                if (!this.controller.isRunning(service)) {
                    return;
                }
                ApplicationJava javaApp = this.context.terminal().master().applicationJavas().filter(a -> (this.context.hostName() + "." + service.identifier()).equals(a.id())).findFirst().orElse(null);
                if (javaApp == null) {
                    return;
                }
                List<ObservableAssertion.Operation> operations = this.operations(service);
                if (!this.equals(operations, javaApp.operationList())) {
                    this.context.terminal().publish(this.map(service, operations, javaApp.operationList()));
                }
            }
            catch (Exception e) {
                Logger.error((String)e.getMessage());
            }
        }

        private List<ObservableAssertion.Operation> operations(Service service) {
            List<ObservableAssertion.Operation.Procedure> procedures = new JavaApplicationConnector(this.context.system()).proceduresOf(service);
            List<ObservableAssertion.Operation> operations = JavaOperationService.activityOperations();
            operations.stream().filter(o -> o.name().equals("execute-procedure")).findFirst().get().procedureList(procedures);
            return operations;
        }

        private boolean equals(List<ObservableAssertion.Operation> operations, List<Observable.Operation> currentOperations) {
            Map<String, Observable.Operation> operationsByName = currentOperations.stream().collect(Collectors.toMap(k -> k.activity() + "##" + k.name(), k -> k));
            for (ObservableAssertion.Operation operation : operations) {
                String key = operation.activity() + "##" + operation.name();
                if (operationsByName.containsKey(key) && this.toString(operationsByName.get(key)).equals(operation.toMessage().toString())) continue;
                return false;
            }
            return true;
        }

        private String toString(Observable.Operation operation) {
            return this.assertionOf(operation).toMessage().toString();
        }

        private ObservableAssertion.Operation assertionOf(Observable.Operation operation) {
            List procedures = operation.procedureList() == null ? Collections.emptyList() : this.procedures(operation);
            ObservableAssertion.Operation assertion = new ObservableAssertion.Operation().name(operation.name()).activity(operation.activity());
            if (procedures != null) {
                assertion.procedureList(procedures);
            }
            return assertion;
        }

        private List<ObservableAssertion.Operation.Procedure> procedures(Observable.Operation operation) {
            return operation.procedureList().stream().map(this::procedureOf).toList();
        }

        private ObservableAssertion.Operation.Procedure procedureOf(Observable.Operation.Procedure p) {
            ObservableAssertion.Operation.Procedure procedure = new ObservableAssertion.Operation.Procedure().name(p.name()).returnType(p.returnType()).description(p.description());
            if (p.parameterList() != null) {
                procedure.parameterList(this.map(p.parameterList()));
            }
            return procedure;
        }

        private List<ObservableAssertion.Operation.Procedure.Parameter> map(List<Observable.Operation.Procedure.Parameter> parameters) {
            return parameters.stream().map((? super T p) -> new ObservableAssertion.Operation.Procedure.Parameter().name(p.name()).type(p.type())).toList();
        }

        private Event map(Service service, List<ObservableAssertion.Operation> operations, List<Observable.Operation> currentOperations) {
            String id = this.context.hostName() + "." + service.identifier();
            ArrayList<ObservableAssertion.Operation> list = new ArrayList<ObservableAssertion.Operation>(operations);
            list.addAll(currentOperations.stream().filter(o -> !o.activity().equals("java-operation-activity")).map(this::assertionOf).toList());
            return new ApplicationJavaAssertion(this.context.observer() + "." + id, id).operationList(list);
        }
    }
}

