/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.javaoperationactivity.operation.deploy;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.framework.Activity;
import io.intino.consul.javaoperationactivity.box.schemas.Service;
import io.intino.consul.javaoperationactivity.operation.deploy.ArtifactResolver;
import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.aether.artifact.Artifact;

public class ServiceDeployer {
    private final Activity.System.OperatingSystem os;
    private final String deployGroup;
    private final String deployUser;
    private final File applicationsDirectory;
    private final File localRepository;
    private File appRunDirectory;

    public ServiceDeployer(Activity.Context context) throws Exception {
        this.applicationsDirectory = new File((String)context.initialConfiguration().get("applications-directory"));
        this.localRepository = new File((String)context.initialConfiguration().get("local-repository"));
        this.deployUser = (String)context.initialConfiguration().get("deploy-user");
        this.deployGroup = (String)context.initialConfiguration().get("deploy-group");
        this.os = context.system().operatingSystem();
    }

    public List<File> deploy(Service service) throws Exception {
        Activity.System.FileSystem fs = this.os.fileSystem();
        this.appRunDirectory = new File(this.applicationsDirectory, service.shortName());
        ArtifactResolver resolver = new ArtifactResolver(this.localRepository);
        List<Artifact> artifacts = resolver.failOverResolveArtifacts(service);
        fs.deleteDirectory(this.appRunDirectory.getAbsolutePath());
        fs.mkdirs(this.appRunDirectory.getAbsolutePath());
        return this.copyToRunDirectory(fs, artifacts, service);
    }

    private List<File> copyToRunDirectory(Activity.System.FileSystem fs, List<Artifact> artifacts, Service service) {
        ArrayList<File> files = new ArrayList<File>();
        try {
            files.add(this.copy(fs, artifacts.get(0), ""));
            File directory = this.dependenciesDirectory(service.artifact().classpathPrefix());
            fs.mkdirs(directory.getAbsolutePath());
            files.addAll(this.copyDependencies(fs, artifacts, service));
            if (this.os.name().contains("Linux")) {
                fs.changeOwner(this.appRunDirectory.getParentFile().getAbsolutePath(), this.deployUser, this.deployGroup);
            }
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
        return files;
    }

    private List<File> copyDependencies(Activity.System.FileSystem fs, List<Artifact> artifacts, Service service) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        for (Artifact artifact : artifacts.subList(1, artifacts.size())) {
            if (artifact.getFile().equals(artifacts.get(0).getFile())) continue;
            files.add(this.copy(fs, artifact, service.artifact().classpathPrefix()));
        }
        return files;
    }

    private File copy(Activity.System.FileSystem fs, Artifact artifact, String classpathPrefix) throws IOException {
        File destination = new File(this.dependenciesDirectory(classpathPrefix), artifact.getFile().getName());
        fs.copy(artifact.getFile().getCanonicalFile().getAbsolutePath(), destination.getAbsolutePath(), new CopyOption[]{StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.COPY_ATTRIBUTES});
        return destination;
    }

    private File dependenciesDirectory(String classpathPrefix) {
        return classpathPrefix.isEmpty() ? this.appRunDirectory : new File(this.appRunDirectory, classpathPrefix);
    }
}

