/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.javaoperationactivity.operation.deploy;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.javaoperationactivity.box.schemas.Service;
import io.intino.consul.javaoperationactivity.operation.deploy.LibraryResolver;
import io.intino.consul.javaoperationactivity.operation.deploy.MavenRepositories;
import io.intino.consul.javaoperationactivity.operation.deploy.MavenSettings;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.maven.settings.IdentifiableBase;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.DependencyResolutionException;
import org.eclipse.aether.resolution.DependencyResult;
import org.eclipse.aether.util.graph.visitor.PreorderNodeListGenerator;

public class ArtifactResolver {
    private static final String CouldNotFindArtifact = "Could not find artifact";
    private final File localRepository;

    public ArtifactResolver(File localRepository) {
        this.localRepository = localRepository;
    }

    List<Artifact> failOverResolveArtifacts(Service service) throws Exception {
        List<Artifact> artifacts;
        try {
            artifacts = this.resolveArtifacts(service);
        }
        catch (DependencyResolutionException e) {
            String error = this.error(e);
            Logger.error((String)error);
            if (this.resolveFailingDependencyArtifact(this.mavenId(error), service)) {
                throw new Exception("Artifacts couldn't be resolved.\n" + error);
            }
            try {
                artifacts = this.resolveArtifacts(service);
            }
            catch (DependencyResolutionException e2) {
                throw new Exception("Artifacts couldn't be resolved.\n" + error);
            }
        }
        return artifacts;
    }

    private boolean resolveFailingDependencyArtifact(String mavenId, Service service) {
        if (mavenId == null) {
            return false;
        }
        Logger.info((String)("Resolving failed dependency " + mavenId));
        try {
            return this.resolveArtifact(new DefaultArtifact(mavenId), service).isEmpty();
        }
        catch (DependencyResolutionException e) {
            return false;
        }
    }

    private String mavenId(String error) {
        if (!error.contains(CouldNotFindArtifact)) {
            return null;
        }
        String substring = error.substring(error.lastIndexOf(CouldNotFindArtifact));
        substring = substring.replace("Could not find artifact ", "");
        return substring.substring(0, substring.indexOf(" ")).trim();
    }

    private List<Artifact> resolveArtifacts(Service service) throws DependencyResolutionException {
        Logger.info((String)("Resolving artifacts of " + service.identifier()));
        this.deleteMainArtifact(this.localRepository, service);
        DefaultArtifact artifact = new DefaultArtifact(service.artifact().identifier());
        return this.resolveArtifact(artifact, service);
    }

    List<Artifact> resolveArtifact(DefaultArtifact artifact, Service service) throws DependencyResolutionException {
        LibraryResolver resolver = new LibraryResolver(this.localRepository, this.repositoriesFrom(service.artifact().artifactoryList()));
        DependencyResult resultCompile = resolver.resolve(artifact, "compile");
        ArrayList<Artifact> dependencies = new ArrayList<Artifact>(ArtifactResolver.artifactsFrom(resultCompile, false));
        dependencies.addAll(ArtifactResolver.artifactsFrom(resolver.resolve(artifact, "runtime"), false));
        return dependencies;
    }

    private List<RemoteRepository> repositoriesFrom(List<Service.Artifact.Artifactory> artifactories) {
        Map servers = MavenSettings.settings().getServers().stream().collect(Collectors.toMap(IdentifiableBase::getId, s -> s, (e1, e2) -> e1, LinkedHashMap::new));
        return artifactories.stream().map(r -> MavenRepositories.repository(r, servers)).collect(Collectors.toList());
    }

    public static List<Artifact> artifactsFrom(DependencyResult result, boolean includeUnresolved) {
        PreorderNodeListGenerator nodeListGenerator = new PreorderNodeListGenerator();
        result.getRoot().accept(nodeListGenerator);
        return nodeListGenerator.getDependencies(includeUnresolved).stream().map(Dependency::getArtifact).collect(Collectors.toList());
    }

    private void deleteMainArtifact(File localRepository, Service service) {
        try {
            Service.Artifact artifact = service.artifact();
            File directory = new File(localRepository, artifact.groupId().replace(".", File.separator) + File.separator + artifact.artifactId() + File.separator + artifact.version());
            FileUtils.deleteDirectory(directory);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String error(DependencyResolutionException e) {
        String stackTrace = ExceptionUtils.getStackTrace(e);
        return Arrays.stream(stackTrace.split("\n")).filter(l -> l.contains(CouldNotFindArtifact) || l.contains("Caused by:")).distinct().collect(Collectors.joining("\n"));
    }
}

