/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.javaoperationactivity.operation;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.framework.Activity;
import io.intino.consul.javaoperationactivity.box.schemas.Service;
import io.intino.consul.javaoperationactivity.deployment.windows.WindowsServiceGenerator;
import io.intino.consul.javaoperationactivity.operation.ServiceHandler;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;

public class WinServiceHandler
implements ServiceHandler {
    private final Service service;
    private final Activity.Context context;
    private final Activity.System.OperatingSystem os;
    private final WindowsServiceGenerator serviceGenerator;

    public WinServiceHandler(Service service, Activity.Context context) throws Exception {
        this.service = service;
        this.context = context;
        this.os = context.system().operatingSystem();
        this.serviceGenerator = new WindowsServiceGenerator(service, context);
    }

    @Override
    public int start() throws Exception {
        this.serviceGenerator.create(false);
        Logger.info((String)("Launching " + this.service.identifier() + "..."));
        String start = this.sc("start");
        if (!start.trim().isEmpty()) {
            Logger.debug((String)start);
        }
        return this.pid();
    }

    @Override
    public int debug() throws Exception {
        this.serviceGenerator.create(true);
        Logger.info((String)("Launching " + this.service.identifier() + " with debug port " + this.service.debugPort() + "..."));
        String start = this.sc("start");
        if (!start.trim().isEmpty()) {
            Logger.debug((String)start);
        }
        return this.pid();
    }

    @Override
    public void stop() {
        Logger.debug((String)this.sc("stop"));
        Logger.info((String)("Stopped " + this.service.identifier()));
    }

    @Override
    public boolean isRunning() {
        String status = null;
        try {
            status = this.sc("query");
            Optional<Integer> i = Arrays.stream(status.split("\n")).filter(l -> l.trim().startsWith("STATE") || l.trim().startsWith("ESTADO")).findFirst().map(l -> l.split(":")[1].trim()).map(l -> Character.valueOf(l.charAt(0))).map(c -> Integer.parseInt("" + c));
            return i.isPresent() && i.get().equals(4);
        }
        catch (Throwable e) {
            Logger.error((String)("Impossible to get exit value of " + this.serviceName() + ";\n" + status + ";\n" + e.getMessage()));
            return false;
        }
    }

    @Override
    public int exitValue() {
        String status = null;
        try {
            status = this.sc("query");
            return Arrays.stream(status.split("\n")).filter(l -> l.trim().contains("EXIT_OF_SERVICE") || l.trim().contains("SALIDA_DEL_SERVICIO")).findFirst().map(l -> l.split(":")[1].trim()).map(l -> l.split(" ")[0].trim()).map(Integer::parseInt).orElse(-1000);
        }
        catch (Throwable e) {
            Logger.error((String)("Impossible to get exit value of " + this.serviceName() + ";\n" + status + ";\n" + e.getMessage()));
            return -1000;
        }
    }

    private String sc(String command) {
        try {
            return this.os.processRunner().execute(List.of("sc", command, this.serviceName()), 5);
        }
        catch (Exception e) {
            Logger.error((String)e.getMessage());
            return "";
        }
    }

    private String serviceName() {
        return (String)this.context.initialConfiguration().get("deploy-user") + "-" + this.service.artifact().artifactId();
    }

    private int pid() {
        String result = null;
        try {
            result = this.os.processRunner().execute(List.of("sc", "queryex", this.serviceName()), 5).trim();
            return result.lines().filter(l -> l.trim().contains("PID")).findFirst().map(l -> l.split(":")).map(split -> Integer.parseInt(split[1].trim())).orElse(-1000);
        }
        catch (Exception e) {
            Logger.error((String)("Impossible to get pid value of " + this.serviceName() + ";\n" + result + ";\n" + e.getMessage()));
            return -1000;
        }
    }
}

