/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.javaoperationactivity.operation;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.framework.Activity;
import io.intino.consul.javaoperationactivity.box.schemas.Service;
import io.intino.consul.javaoperationactivity.operation.LinuxServiceHandler;
import io.intino.consul.javaoperationactivity.operation.ServiceHandler;
import io.intino.consul.javaoperationactivity.operation.WinServiceHandler;
import io.intino.consul.javaoperationactivity.operation.deploy.ServiceDeployer;
import io.intino.consul.terminal.RequestAttendant;
import java.io.File;
import java.util.List;

public class ServiceController {
    private final Activity.Context context;
    private final Activity.Store store;

    public ServiceController(Activity.Context context, Activity.Store store) {
        this.context = context;
        this.store = store;
    }

    public RequestAttendant.RequestResult deploy(Service service) {
        try {
            List<File> result = new ServiceDeployer(this.context).deploy(service);
            service.runFile(result.get(0).getName());
            return new RequestAttendant.RequestResult(true, (Object)"Deployed successfully");
        }
        catch (Exception e) {
            e.printStackTrace();
            Logger.error((String)(e.getClass().getSimpleName() + ":" + e.getMessage()));
            return new RequestAttendant.RequestResult(false, (Object)e.getMessage());
        }
    }

    public boolean start(Service service) {
        try {
            if (service == null || !service.deployed().booleanValue()) {
                return false;
            }
            if (this.isRunning(service)) {
                return true;
            }
            ServiceHandler handler = this.serviceHandler(service);
            int pid = handler.start();
            this.store.put(service.identifier(), (Object)service.pid(pid).status(Service.Status.Running));
            return true;
        }
        catch (Exception e) {
            if (e instanceof NullPointerException) {
                e.printStackTrace();
            } else {
                Logger.error((String)(e.getClass().getSimpleName() + ":" + e.getMessage()));
            }
            return false;
        }
    }

    public boolean debug(Service service) {
        if (service == null || !service.deployed().booleanValue()) {
            return false;
        }
        try {
            this.stop(service);
            Thread.sleep(1000L);
            ServiceHandler handler = this.serviceHandler(service);
            int pid = handler.debug();
            this.store.put(service.identifier(), (Object)service.pid(pid).status(Service.Status.Debug));
            return true;
        }
        catch (Exception e) {
            if (e instanceof NullPointerException) {
                e.printStackTrace();
            } else {
                Logger.error((String)(e.getClass().getSimpleName() + ":" + e.getMessage()));
            }
            return false;
        }
    }

    public boolean stop(Service service) {
        if (service == null) {
            return false;
        }
        try {
            ServiceHandler handler = this.serviceHandler(service);
            handler.stop();
            this.store.put(service.identifier(), (Object)service.pid(0).ppid(0).status(Service.Status.Stopped));
            Logger.info((String)("Service " + service.identifier() + " stopped"));
            return true;
        }
        catch (Exception e) {
            if (e instanceof NullPointerException) {
                e.printStackTrace();
            } else {
                Logger.error((String)(e.getClass().getSimpleName() + ":" + e.getMessage()));
            }
            return false;
        }
    }

    public boolean restart(Service service) {
        try {
            boolean stop = this.stop(service);
            if (!stop) {
                return false;
            }
            Thread.sleep(1000L);
            return this.start(service);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return false;
        }
    }

    public boolean isRunning(Service service) throws Exception {
        return service != null && this.serviceHandler(service).isRunning();
    }

    public ServiceHandler serviceHandler(Service service) throws Exception {
        return this.context.system().operatingSystem().name().contains("Linux") ? new LinuxServiceHandler(service, this.context) : new WinServiceHandler(service, this.context);
    }
}

