/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.javaoperationactivity.operation;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.framework.Activity;
import io.intino.consul.javaoperationactivity.box.schemas.Service;
import io.intino.consul.javaoperationactivity.deployment.unix.UnixServiceGenerator;
import io.intino.consul.javaoperationactivity.operation.ServiceHandler;
import java.util.Arrays;

public class LinuxServiceHandler
implements ServiceHandler {
    private final Service service;
    private final Activity.Context context;
    private final Activity.System.OperatingSystem os;
    private final UnixServiceGenerator serviceGenerator;

    public LinuxServiceHandler(Service service, Activity.Context context) throws Exception {
        this.service = service;
        this.context = context;
        this.os = context.system().operatingSystem();
        this.serviceGenerator = new UnixServiceGenerator(service, context);
    }

    @Override
    public int start() throws Exception {
        String enable;
        this.serviceGenerator.create(false);
        Logger.info((String)("Launching " + this.service.identifier() + "..."));
        String start = this.systemctl("start");
        if (!start.trim().isEmpty()) {
            Logger.debug((String)start);
        }
        if (!(enable = this.systemctl("enable")).trim().isEmpty()) {
            Logger.debug((String)enable);
        }
        return this.pid();
    }

    @Override
    public int debug() throws Exception {
        String enable;
        this.serviceGenerator.create(true);
        Logger.info((String)("Launching " + this.service.identifier() + " with debug port " + this.service.debugPort() + "..."));
        String start = this.systemctl("start");
        if (!start.trim().isEmpty()) {
            Logger.debug((String)start);
        }
        if (!(enable = this.systemctl("enable")).trim().isEmpty()) {
            Logger.debug((String)enable);
        }
        return this.pid();
    }

    @Override
    public void stop() {
        Logger.debug((String)this.systemctl("stop"));
        Logger.debug((String)this.systemctl("disable"));
        this.serviceGenerator.delete();
        Logger.info((String)("Stopped " + this.service.identifier()));
    }

    @Override
    public boolean isRunning() {
        try {
            String result = this.os.processRunner().execute(new String[]{"systemctl", "show", "--value", "--property", "SubState", this.serviceName()}).trim();
            return "running".equals(result);
        }
        catch (Exception e) {
            Logger.error((String)e.getMessage());
            return false;
        }
    }

    @Override
    public int exitValue() {
        String status = null;
        try {
            status = this.systemctl("status");
            String statusStr = "status=";
            return Arrays.stream(status.split("\n")).filter(l -> l.trim().startsWith("Main PID:") && l.contains("status=")).map(l -> l.split("status=")[1].replace(")", "").trim().split("/")[0]).map(Integer::parseInt).findFirst().orElse(-1000);
        }
        catch (Throwable e) {
            Logger.error((String)("Impossible to get exit value of " + this.service.artifact().identifier() + ";\n" + status));
            return -1000;
        }
    }

    private int pid() {
        String status = this.systemctl("status");
        String prefix = "Main PID:";
        return Arrays.stream(status.split("\n")).filter(l -> l.trim().startsWith(prefix)).map(l -> l.replace(prefix, "").trim().split(" ")[0]).map(Integer::parseInt).findFirst().orElse(-1000);
    }

    private String systemctl(String command) {
        try {
            return this.os.processRunner().execute(new String[]{"systemctl", command, this.serviceName()});
        }
        catch (Exception e) {
            Logger.error((String)e.getMessage());
            return null;
        }
    }

    private String serviceName() {
        return (String)this.context.initialConfiguration().get("deploy-user") + "-" + this.service.artifact().artifactId();
    }
}

