/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.javaoperationactivity.deployment.unix;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.framework.Activity;
import io.intino.consul.javaoperationactivity.box.schemas.Service;
import io.intino.consul.javaoperationactivity.deployment.unix.ServiceTemplate;
import io.intino.consul.javaoperationactivity.deployment.unix.SyslogTemplate;
import io.intino.itrules.Frame;
import io.intino.itrules.FrameBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.StandardOpenOption;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class UnixServiceGenerator {
    private final Service service;
    private final String artifactName;
    private final String deployUser;
    private final File applicationsDirectory;
    private final File logsDirectory;
    private final File applicationsWorkspace;
    private final File tmpDirectory;
    private final String javaHome;
    private final Activity.System.OperatingSystem os;

    public UnixServiceGenerator(Service service, Activity.Context context) throws Exception {
        this.service = service;
        this.artifactName = service.artifact().artifactId();
        this.os = context.system().operatingSystem();
        this.deployUser = (String)context.initialConfiguration().get("deploy-user");
        this.applicationsDirectory = new File((String)context.initialConfiguration().get("applications-directory"));
        this.logsDirectory = new File((String)context.initialConfiguration().get("logs-directory"));
        this.applicationsWorkspace = new File((String)context.initialConfiguration().get("applications-workspace"));
        this.tmpDirectory = new File((String)context.initialConfiguration().get("tmp-directory"));
        this.javaHome = (String)context.initialConfiguration().get("java-home");
    }

    public void create(boolean debug) {
        try {
            FrameBuilder builder = this.frame(debug);
            Activity.System.ProcessRunner runner = this.os.processRunner();
            Activity.System.FileSystem fs = this.os.fileSystem();
            fs.writeString(this.syslogPath(), new SyslogTemplate().render(builder.add("syslog").toFrame()));
            fs.writeString(this.serviceFile(), new ServiceTemplate().render(builder.add("service").toFrame()));
            fs.writeString(this.postActionFilePath(), new ServiceTemplate().render(builder.add("postAction").toFrame()));
            this.updateSudoers(fs);
            this.updateServices(runner);
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
    }

    public void delete() {
        try {
            this.os.fileSystem().delete(this.postActionFilePath());
        }
        catch (IOException e) {
            Logger.error((Throwable)e);
        }
    }

    private void updateServices(Activity.System.ProcessRunner executor) throws Exception {
        String execute = executor.execute(new String[]{"systemctl", "daemon-reload"});
        if (!execute.isEmpty()) {
            Logger.debug((String)execute.trim());
        }
        if (!(execute = executor.execute(new String[]{"systemctl", "enable", this.serviceName()})).isEmpty()) {
            Logger.debug((String)execute.trim());
        }
        if (!(execute = executor.execute(new String[]{"systemctl", "restart", "rsyslog"})).isEmpty()) {
            Logger.debug((String)execute.trim());
        }
    }

    private void updateSudoers(Activity.System.FileSystem fs) {
        List<String> servicesAlreadyAdded = this.loadSudoers();
        if (servicesAlreadyAdded.contains(this.artifactName)) {
            return;
        }
        fs.writeString(this.sudoersFile().getAbsolutePath(), this.sudoersTemplate().replace("$artifactName", this.artifactName), new StandardOpenOption[]{StandardOpenOption.CREATE, StandardOpenOption.APPEND});
    }

    private String postActionFilePath() {
        if (new File("/etc/dnf/plugins/post-transaction-actions.d/").exists()) {
            return new File(String.format("/etc/dnf/plugins/post-transaction-actions.d/%s.action", this.serviceName())).getAbsolutePath();
        }
        return new File(String.format("/etc/yum/post-actions/%s.action", this.serviceName())).getAbsolutePath();
    }

    private List<String> loadSudoers() {
        try {
            File sudoersFile = this.sudoersFile();
            Activity.System.FileSystem fs = this.os.fileSystem();
            String content = fs.readFile(sudoersFile.getAbsolutePath());
            if (content == null || content.isEmpty()) {
                return Collections.emptyList();
            }
            return this.reduceByService(Stream.of(content.split("\n")));
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
            return Collections.emptyList();
        }
    }

    private File sudoersFile() {
        return new File("/etc/sudoers.d/" + this.deployUser);
    }

    private List<String> reduceByService(Stream<String> lines) {
        return lines.filter(l -> !l.trim().isEmpty()).map(this::findService).distinct().collect(Collectors.toList());
    }

    private String findService(String l) {
        String[] words = l.split(" ");
        return words[words.length - 1].trim();
    }

    private String syslogPath() {
        return new File("/etc/rsyslog.d/", this.serviceName() + ".conf").getAbsolutePath();
    }

    private String serviceFile() {
        return new File("/etc/systemd/system/", this.serviceName() + ".service").getAbsolutePath();
    }

    private String serviceName() {
        return this.deployUser + "-" + this.artifactName.toLowerCase();
    }

    private FrameBuilder frame(boolean debug) {
        FrameBuilder builder = new FrameBuilder().add("artifact", this.artifactName).add("service", this.serviceName()).add("user", this.deployUser).add("applicationsDirectory", this.applicationsDirectory.getAbsolutePath()).add("logsDirectory", this.logsDirectory.getAbsolutePath()).add("home", this.applicationsWorkspace.getAbsolutePath()).add("tmp", this.tmpDirectory.getAbsolutePath()).add("java", this.javaHome != null ? this.javaHome : System.getProperty("java.home")).add("javaVersion", this.javaVersion()).add("managementPort", this.service.managementPort()).add("parameter", this.parameters()).add("restart", "Restart");
        if (debug) {
            builder.add("debug", this.service.debugPort());
        }
        if (this.service.runFile() != null) {
            builder.add("artifactFile", new File(this.service.runFile()).getName());
        }
        if (this.service.artifact().mainClass() != null) {
            builder.add("withClassPath").add("mainClass", this.service.artifact().mainClass());
        }
        if (this.service.artifact().classpathPrefix() != null) {
            builder.add("dependencies", this.directoryFrame());
        }
        if (this.service.requirements() != null && this.service.requirements().minMemory() > 0) {
            builder.add("minMemory", this.service.requirements().minMemory());
        }
        if (this.service.requirements() != null && this.service.requirements().maxMemory() > 0) {
            builder.add("maxMemory", this.service.requirements().maxMemory());
        }
        return builder;
    }

    private String javaVersion() {
        if (this.javaHome != null) {
            return new File(this.javaHome).getName().split("-")[1];
        }
        return System.getProperty("java.version").split("\\.")[0];
    }

    private Frame directoryFrame() {
        return new FrameBuilder("dependencies").add("applicationsDirectory", this.applicationsDirectory.getAbsolutePath()).add("artifact", this.service.artifact().artifactId()).add("directory", this.service.artifact().classpathPrefix()).toFrame();
    }

    private Frame[] parameters() {
        return (Frame[])this.service.parameterList().stream().map(p -> new FrameBuilder("parameter").add("name", p.name()).add("value", p.value()).toFrame()).toArray(Frame[]::new);
    }

    private String sudoersTemplate() {
        return "intino ALL= (root) NOPASSWD: /bin/systemctl start $artifactName\nintino ALL= (root) NOPASSWD: /bin/systemctl stop $artifactName\nintino ALL= (root) NOPASSWD: /bin/systemctl restart $artifactName\nintino ALL= (root) NOPASSWD: /bin/systemctl status $artifactName\n\n";
    }
}

