/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.javaoperationactivity.box.schemas;

import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class Service
implements Serializable {
    private Instant creationTime;
    private String project;
    private String identifier;
    private String shortName;
    private String workspace;
    private Boolean deployed = false;
    private Status status;
    private int managementPort = 0;
    private int debugPort = 0;
    private int pid = 0;
    private int ppid = 0;
    private String runFile;
    private List<String> jvmParameters = new ArrayList<String>();
    private Requirements requirements;
    private Artifact artifact;
    private List<Parameter> parameter = new ArrayList<Parameter>();

    public Instant creationTime() {
        return this.creationTime;
    }

    public String project() {
        return this.project;
    }

    public String identifier() {
        return this.identifier;
    }

    public String shortName() {
        return this.shortName;
    }

    public String workspace() {
        return this.workspace;
    }

    public Boolean deployed() {
        return this.deployed;
    }

    public Status status() {
        return this.status;
    }

    public int managementPort() {
        return this.managementPort;
    }

    public int debugPort() {
        return this.debugPort;
    }

    public int pid() {
        return this.pid;
    }

    public int ppid() {
        return this.ppid;
    }

    public String runFile() {
        return this.runFile;
    }

    public List<String> jvmParameters() {
        return this.jvmParameters;
    }

    public Requirements requirements() {
        return this.requirements;
    }

    public Artifact artifact() {
        return this.artifact;
    }

    public List<Parameter> parameterList() {
        return this.parameter;
    }

    public List<Parameter> parameterList(Predicate<Parameter> predicate) {
        return this.parameter.stream().filter(predicate).collect(Collectors.toList());
    }

    public Parameter parameter(Predicate<Parameter> predicate) {
        return this.parameter.stream().filter(predicate).findFirst().orElse(null);
    }

    public Service creationTime(Instant creationTime) {
        this.creationTime = creationTime;
        return this;
    }

    public Service project(String project) {
        this.project = project;
        return this;
    }

    public Service identifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public Service shortName(String shortName) {
        this.shortName = shortName;
        return this;
    }

    public Service workspace(String workspace) {
        this.workspace = workspace;
        return this;
    }

    public Service deployed(Boolean deployed) {
        this.deployed = deployed;
        return this;
    }

    public Service status(Status status) {
        this.status = status;
        return this;
    }

    public Service managementPort(int managementPort) {
        this.managementPort = managementPort;
        return this;
    }

    public Service debugPort(int debugPort) {
        this.debugPort = debugPort;
        return this;
    }

    public Service pid(int pid) {
        this.pid = pid;
        return this;
    }

    public Service ppid(int ppid) {
        this.ppid = ppid;
        return this;
    }

    public Service runFile(String runFile) {
        this.runFile = runFile;
        return this;
    }

    public Service jvmParameters(List<String> jvmParameters) {
        this.jvmParameters = jvmParameters;
        return this;
    }

    public Service requirements(Requirements requirements) {
        this.requirements = requirements;
        return this;
    }

    public Service artifact(Artifact artifact) {
        this.artifact = artifact;
        return this;
    }

    public Service parameterList(List<Parameter> parameter) {
        this.parameter = parameter;
        return this;
    }

    public static enum Status {
        Running,
        Stopped,
        Debug;

    }

    public static class Requirements
    implements Serializable {
        private int minMemory = 0;
        private int maxMemory = 0;

        public int minMemory() {
            return this.minMemory;
        }

        public int maxMemory() {
            return this.maxMemory;
        }

        public Requirements minMemory(int minMemory) {
            this.minMemory = minMemory;
            return this;
        }

        public Requirements maxMemory(int maxMemory) {
            this.maxMemory = maxMemory;
            return this;
        }
    }

    public static class Artifact
    implements Serializable {
        private String groupId;
        private String artifactId;
        private String version;
        private String identifier;
        private String classpathPrefix = "dependency";
        private String mainClass;
        private List<Artifactory> artifactory = new ArrayList<Artifactory>();

        public String groupId() {
            return this.groupId;
        }

        public String artifactId() {
            return this.artifactId;
        }

        public String version() {
            return this.version;
        }

        public String identifier() {
            return this.identifier;
        }

        public String classpathPrefix() {
            return this.classpathPrefix;
        }

        public String mainClass() {
            return this.mainClass;
        }

        public List<Artifactory> artifactoryList() {
            return this.artifactory;
        }

        public List<Artifactory> artifactoryList(Predicate<Artifactory> predicate) {
            return this.artifactory.stream().filter(predicate).collect(Collectors.toList());
        }

        public Artifactory artifactory(Predicate<Artifactory> predicate) {
            return this.artifactory.stream().filter(predicate).findFirst().orElse(null);
        }

        public Artifact groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        public Artifact artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        public Artifact version(String version) {
            this.version = version;
            return this;
        }

        public Artifact identifier(String identifier) {
            this.identifier = identifier;
            return this;
        }

        public Artifact classpathPrefix(String classpathPrefix) {
            this.classpathPrefix = classpathPrefix;
            return this;
        }

        public Artifact mainClass(String mainClass) {
            this.mainClass = mainClass;
            return this;
        }

        public Artifact artifactoryList(List<Artifactory> artifactory) {
            this.artifactory = artifactory;
            return this;
        }

        public static class Artifactory
        implements Serializable {
            private String url;
            private String mavenId;
            private String user;
            private String password;
            private Boolean snapshot = false;

            public String url() {
                return this.url;
            }

            public String mavenId() {
                return this.mavenId;
            }

            public String user() {
                return this.user;
            }

            public String password() {
                return this.password;
            }

            public Boolean snapshot() {
                return this.snapshot;
            }

            public Artifactory url(String url) {
                this.url = url;
                return this;
            }

            public Artifactory mavenId(String mavenId) {
                this.mavenId = mavenId;
                return this;
            }

            public Artifactory user(String user) {
                this.user = user;
                return this;
            }

            public Artifactory password(String password) {
                this.password = password;
                return this;
            }

            public Artifactory snapshot(Boolean snapshot) {
                this.snapshot = snapshot;
                return this;
            }
        }
    }

    public static class Parameter
    implements Serializable {
        private String name;
        private String value;

        public String name() {
            return this.name;
        }

        public String value() {
            return this.value;
        }

        public Parameter name(String name) {
            this.name = name;
            return this;
        }

        public Parameter value(String value) {
            this.value = value;
            return this;
        }
    }
}

