/*
 * Decompiled with CFR 0.152.
 */
package com.google.inject.internal;

import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.MapMaker;
import com.google.inject.Key;
import com.google.inject.internal.ProvisionListenerStackCallback;
import com.google.inject.spi.ProvisionListener;
import com.google.inject.spi.ProvisionListenerBinding;
import java.util.AbstractCollection;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class ProvisionListenerCallbackStore {
    private final ImmutableList<ProvisionListenerBinding> listenerBindings;
    private final Map<Key<?>, ProvisionListenerStackCallback<?>> cache = new MapMaker().makeComputingMap(new Function<Key<?>, ProvisionListenerStackCallback<?>>(){

        @Override
        public ProvisionListenerStackCallback<?> apply(Key<?> key) {
            return ProvisionListenerCallbackStore.this.create(key);
        }
    });

    ProvisionListenerCallbackStore(List<ProvisionListenerBinding> listenerBindings) {
        this.listenerBindings = ImmutableList.copyOf(listenerBindings);
    }

    public <T> ProvisionListenerStackCallback<T> get(Key<T> key) {
        return this.cache.get(key);
    }

    boolean remove(Key<?> type) {
        return this.cache.remove(type) != null;
    }

    private <T> ProvisionListenerStackCallback<T> create(Key<T> key) {
        AbstractCollection listeners = null;
        for (ProvisionListenerBinding binding : this.listenerBindings) {
            if (!binding.getKeyMatcher().matches(key)) continue;
            if (listeners == null) {
                listeners = Lists.newArrayList();
            }
            listeners.addAll(binding.getListeners());
        }
        if (listeners == null) {
            listeners = ImmutableList.of();
        }
        return new ProvisionListenerStackCallback<T>(key, (List<ProvisionListener>)((Object)listeners));
    }
}

