/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.javaoperationactivity.service.requests;

import io.intino.alexandria.Resource;
import io.intino.alexandria.exceptions.AlexandriaException;
import io.intino.alexandria.jmx.JMXClient;
import io.intino.alexandria.logger.Logger;
import io.intino.consul.framework.Activity;
import io.intino.consul.javaoperationactivity.box.schemas.Procedure;
import io.intino.consul.javaoperationactivity.box.schemas.Service;
import io.intino.consul.javaoperationactivity.operation.ServiceController;
import io.intino.consul.terminal.RequestAttendant;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.lang.reflect.Array;
import java.time.Instant;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.ObjectName;

public class ExecuteOperationRequest
implements RequestAttendant {
    public static final String ID = "execute-procedure";
    private final Activity.Context context;
    private final Activity.Store store;
    private final ServiceController controller;
    private final String ip;

    public ExecuteOperationRequest(Activity.Context context, Activity.Store store) {
        this.context = context;
        this.store = store;
        this.controller = new ServiceController(context, store);
        this.ip = context.system().network().localIP();
    }

    public String id() {
        return ID;
    }

    public RequestAttendant.RequestResult responseTo(Message request) {
        try {
            Procedure procedure = this.procedure(request);
            String observable = this.parameter(request, "observable");
            if (procedure == null || observable == null) {
                return new RequestAttendant.RequestResult(false, (Object)"operation not found");
            }
            Service service = this.services().filter(s -> (this.context.hostName() + "." + s.identifier()).equals(observable)).findFirst().orElse(null);
            if (service == null) {
                return new RequestAttendant.RequestResult(false, (Object)"Service not found");
            }
            return this.executeOperation(service, procedure);
        }
        catch (AlexandriaException | Exception e) {
            return new RequestAttendant.RequestResult(false, (Object)e.getMessage());
        }
    }

    public boolean isAvailable(Message message) {
        return false;
    }

    private RequestAttendant.RequestResult executeOperation(Service service, Procedure procedure) throws AlexandriaException, Exception {
        RequestAttendant.RequestResult requestResult;
        block13: {
            if (!this.controller.isRunning(service)) {
                throw new AlexandriaException("0", "Service is stopped");
            }
            JMXClient.JMXConnection connection = new JMXClient(this.ip, service.managementPort()).connect();
            try {
                Object[] objectArray;
                String[] nameWithContext = procedure.name().split("::");
                ObjectName objectName = connection.findObjectName(nameWithContext[0]);
                if (objectName == null) {
                    throw new AlexandriaException("0", "Operation not found");
                }
                MBeanOperationInfo op = connection.operationInfos(objectName).keySet().stream().filter(i -> i.getName().equals(nameWithContext[1])).findFirst().orElse(null);
                if (op == null) {
                    throw new AlexandriaException("0", "Operation not found");
                }
                if (op.getSignature().length > 0 && op.getSignature()[0].getType().contains("List")) {
                    Object[] objectArray2 = new Object[1];
                    objectArray = objectArray2;
                    objectArray2[0] = procedure.parameters();
                } else {
                    objectArray = this.transform(op.getSignature(), procedure.parameters());
                }
                Object[] parameters = objectArray;
                Object result = connection.invokeOperation(objectName, op, parameters);
                String remarks = result instanceof List ? (String)((List)result).stream().map(Object::toString).reduce((t, u) -> t + "\n" + u).get() : result.toString();
                requestResult = new RequestAttendant.RequestResult(true, (Object)remarks);
                if (connection == null) break block13;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new AlexandriaException("0", e.getMessage());
                }
            }
            connection.close();
        }
        return requestResult;
    }

    private Stream<Service> services() {
        return this.store.keys().map(k -> (Service)this.store.get(k, Service.class));
    }

    private Procedure procedure(Message request) {
        try {
            return (Procedure)this.parameter(request, "procedure", Procedure.class);
        }
        catch (JMSException e) {
            Logger.error((Throwable)e);
            return null;
        }
    }

    private boolean isOf(String chain, Integer pid) {
        boolean bl;
        block8: {
            JMXClient.JMXConnection connection = new JMXClient(chain).connect();
            try {
                RuntimeMXBean bean = (RuntimeMXBean)connection.mBean(RuntimeMXBean.class, ManagementFactory.getRuntimeMXBean().getObjectName());
                boolean bl2 = bl = bean.getPid() == pid.longValue();
                if (connection == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    Logger.error((Throwable)e);
                    return false;
                }
            }
            connection.close();
        }
        return bl;
    }

    private Object[] transform(MBeanParameterInfo[] paramters, List<String> parameters) {
        ArrayList<Object> objects = new ArrayList<Object>();
        for (int i = 0; i < paramters.length; ++i) {
            MBeanParameterInfo parameter = paramters[i];
            if (parameter.getType().equals(String.class.getName())) {
                objects.add(parameters.get(i));
                continue;
            }
            Parsers.Parser parser = this.getParser(parameter);
            if (parser == null) {
                return new Object[0];
            }
            objects.add(parser.parse(parameters.get(i)));
        }
        return objects.toArray();
    }

    private Parsers.Parser getParser(MBeanParameterInfo parameter) {
        try {
            return TypeParsers.get(Class.forName(parameter.getType()));
        }
        catch (ClassNotFoundException e) {
            return null;
        }
    }

    public static class Parsers {
        private static final String NullValue = "\u0000";
        private static final Map<Class, Parser> parsers = new HashMap<Class, Parser>();

        public static Parser get(Class<?> aClass) {
            return parsers.get(aClass);
        }

        public static void put(Class<?> aClass, Parser parser) {
            parsers.put(aClass, parser);
        }

        static {
            parsers.put(Boolean.TYPE, Boolean::parseBoolean);
            parsers.put(Byte.TYPE, Byte::parseByte);
            parsers.put(Integer.TYPE, Integer::parseInt);
            parsers.put(Float.TYPE, Float::parseFloat);
            parsers.put(Double.TYPE, Double::parseDouble);
            parsers.put(Long.TYPE, Long::parseLong);
            parsers.put(Boolean.class, parsers.get(Boolean.TYPE));
            parsers.put(Byte.class, parsers.get(Byte.TYPE));
            parsers.put(Integer.class, parsers.get(Integer.TYPE));
            parsers.put(Long.class, parsers.get(Long.TYPE));
            parsers.put(Float.class, parsers.get(Float.TYPE));
            parsers.put(Double.class, parsers.get(Double.TYPE));
            parsers.put(String.class, text -> text);
            parsers.put(Instant.class, Instant::parse);
            parsers.put(Boolean[].class, ArrayParser.of(Boolean.class)::parse);
            parsers.put(Byte[].class, ArrayParser.of(Byte.class)::parse);
            parsers.put(Integer[].class, ArrayParser.of(Integer.class)::parse);
            parsers.put(Float[].class, ArrayParser.of(Float.class)::parse);
            parsers.put(Long[].class, ArrayParser.of(Long.class)::parse);
            parsers.put(Double[].class, ArrayParser.of(Double.class)::parse);
            parsers.put(String[].class, ArrayParser.of(String.class)::parse);
            parsers.put(Instant[].class, ArrayParser.of(Instant.class)::parse);
            parsers.put(Resource[].class, ArrayParser.of(Resource.class)::parse);
        }

        public static interface Parser {
            public Object parse(String var1);
        }

        private static class ArrayParser {
            private final Class type;
            private final Parser parser;

            ArrayParser(Class type, Parser parser) {
                this.type = type;
                this.parser = parser;
            }

            static ArrayParser of(Class type) {
                return new ArrayParser(type, parsers.get(type));
            }

            Object parse(String text) {
                String[] lines = text.split("\n");
                Object result = Array.newInstance(this.type, lines.length);
                for (int i = 0; i < lines.length; ++i) {
                    Array.set(result, i, Parsers.NullValue.equals(lines[i]) ? null : this.parser.parse(lines[i]));
                }
                return result;
            }
        }
    }

    public static class TypeParsers {
        private static final Map<Class, Parsers.Parser> parsers = new HashMap<Class, Parsers.Parser>();

        public static Parsers.Parser get(Class<?> aClass) {
            return parsers.get(aClass);
        }

        static {
            parsers.put(Boolean.TYPE, Boolean::parseBoolean);
            parsers.put(Byte.TYPE, Byte::parseByte);
            parsers.put(Integer.TYPE, Integer::parseInt);
            parsers.put(Float.TYPE, Float::parseFloat);
            parsers.put(Double.TYPE, Double::parseDouble);
            parsers.put(Long.TYPE, Long::parseLong);
            parsers.put(Boolean.class, parsers.get(Boolean.TYPE));
            parsers.put(Byte.class, parsers.get(Byte.TYPE));
            parsers.put(Integer.class, parsers.get(Integer.TYPE));
            parsers.put(Long.class, parsers.get(Long.TYPE));
            parsers.put(Float.class, parsers.get(Float.TYPE));
            parsers.put(Double.class, parsers.get(Double.TYPE));
            parsers.put(String.class, text -> text);
            parsers.put(Instant.class, Instant::parse);
        }
    }
}

