/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.javaoperationactivity.sentinels;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.scheduler.AlexandriaScheduler;
import io.intino.consul.framework.Activity;
import io.intino.consul.javaoperationactivity.sentinels.ScheduleRefreshOperationsSentinel;
import java.util.Set;
import org.quartz.CronScheduleBuilder;
import org.quartz.CronTrigger;
import org.quartz.JobBuilder;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.SchedulerException;
import org.quartz.TriggerBuilder;

public class Sentinels {
    private Sentinels() {
    }

    public static void init(String id, AlexandriaScheduler scheduler, Activity.Context context, Activity.Store store) {
        try {
            Sentinels.refreshOperations(id, scheduler, context, store);
        }
        catch (Exception e) {
            Logger.error((String)e.getMessage());
        }
    }

    private static void refreshOperations(String id, AlexandriaScheduler scheduler, Activity.Context context, Activity.Store store) throws SchedulerException {
        JobDetail job = JobBuilder.newJob(ScheduleRefreshOperationsSentinel.class).withIdentity(id + "-refreshOperations").build();
        job.getJobDataMap().put("context", (Object)context);
        job.getJobDataMap().put("store", (Object)store);
        scheduler.scheduleJob(job, Set.of((CronTrigger)TriggerBuilder.newTrigger().withIdentity(id + "-refreshOperationsSentinel").withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)"0 0/1 * 1/1 * ? *")).build()), true);
    }
}

