/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.javaoperationactivity.operation.deploy;

import com.jcabi.aether.Aether;
import io.intino.consul.javaoperationactivity.box.schemas.Service;
import io.intino.consul.javaoperationactivity.operation.deploy.ArtifactoryConnector;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.maven.settings.IdentifiableBase;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.SettingsUtils;
import org.apache.maven.settings.building.DefaultSettingsBuilder;
import org.apache.maven.settings.building.DefaultSettingsBuilderFactory;
import org.apache.maven.settings.building.DefaultSettingsBuildingRequest;
import org.apache.maven.settings.building.SettingsBuilder;
import org.apache.maven.settings.building.SettingsBuildingException;
import org.apache.maven.settings.building.SettingsBuildingResult;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.graph.DependencyFilter;
import org.sonatype.aether.repository.Authentication;
import org.sonatype.aether.repository.Proxy;
import org.sonatype.aether.repository.RemoteRepository;
import org.sonatype.aether.repository.RepositoryPolicy;
import org.sonatype.aether.resolution.DependencyResolutionException;

public class LibraryResolver {
    public static final String MAVEN_REPOSITORY = "https://repo1.maven.org/maven2/";
    private final Aether aether;

    public LibraryResolver(File localRepository, List<Service.Artifact.Artifactory> artifactories) {
        Map servers = this.settings().getServers().stream().collect(Collectors.toMap(IdentifiableBase::getId, s -> s, (e1, e2) -> e1, LinkedHashMap::new));
        List<RemoteRepository> repositories = artifactories.stream().filter(a -> ArtifactoryConnector.ArtifactoryChecker.isRunning(a.url())).distinct().map(r -> this.repository((Service.Artifact.Artifactory)r, servers)).collect(Collectors.toList());
        repositories.forEach(this::addProxies);
        repositories.add(0, new RemoteRepository("maven-central", "default", MAVEN_REPOSITORY).setPolicy(false, new RepositoryPolicy().setEnabled(true).setUpdatePolicy("daily")));
        this.aether = new Aether(repositories, localRepository);
    }

    public LibraryResolver(File localRepository, String id, String type, String url) {
        this.aether = new Aether(Collections.singletonList(this.addProxies(new RemoteRepository(id, type, url))), localRepository);
    }

    private RemoteRepository repository(Service.Artifact.Artifactory r, Map<String, Server> servers) {
        Authentication authentication = this.provideAuthentication(r, servers);
        RemoteRepository repository = new RemoteRepository(r.mavenId(), "default", r.url()).setAuthentication(authentication);
        if (r.snapshot().booleanValue()) {
            repository.setPolicy(true, new RepositoryPolicy().setEnabled(true).setUpdatePolicy("always"));
            repository.setPolicy(false, new RepositoryPolicy().setEnabled(false));
        } else {
            repository.setPolicy(true, new RepositoryPolicy().setEnabled(false).setUpdatePolicy("always"));
            repository.setPolicy(false, new RepositoryPolicy().setEnabled(true).setUpdatePolicy("daily"));
        }
        return repository;
    }

    private Authentication provideAuthentication(Service.Artifact.Artifactory artifactory, Map<String, Server> servers) {
        if (servers.containsKey(artifactory.mavenId())) {
            return new Authentication(servers.get(artifactory.mavenId()).getUsername(), servers.get(artifactory.mavenId()).getPassword());
        }
        if (artifactory.user() != null) {
            return new Authentication(artifactory.user(), artifactory.password());
        }
        return null;
    }

    private RemoteRepository addProxies(RemoteRepository r) {
        if (System.getProperty("http.proxyHost") != null) {
            r.setProxy(new Proxy("http", System.getProperty("http.proxyHost"), Integer.parseInt(System.getProperty("http.proxyPort")), null));
        }
        return r;
    }

    public List<Artifact> resolve(Artifact root, String scope) throws DependencyResolutionException {
        return this.aether.resolve(root, scope);
    }

    public List<Artifact> resolve(Artifact root, String scope, DependencyFilter filter) throws DependencyResolutionException {
        return this.aether.resolve(root, scope, filter);
    }

    private Settings settings() {
        SettingsBuildingResult result;
        DefaultSettingsBuilder builder = new DefaultSettingsBuilderFactory().newInstance();
        DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest();
        String user = System.getProperty("org.apache.maven.user-settings");
        if (user == null) {
            request.setUserSettingsFile(new File(new File(System.getProperty("user.home")).getAbsoluteFile(), "/.m2/settings.xml"));
        } else {
            request.setUserSettingsFile(new File(user));
        }
        String global = System.getProperty("org.apache.maven.global-settings");
        if (global != null) {
            request.setGlobalSettingsFile(new File(global));
        }
        try {
            result = builder.build(request);
        }
        catch (SettingsBuildingException ex) {
            throw new IllegalStateException(ex);
        }
        return this.invokers(builder, result);
    }

    private Settings invokers(SettingsBuilder builder, SettingsBuildingResult result) {
        Settings main = result.getEffectiveSettings();
        Path path = Paths.get(System.getProperty("user.dir"), "..", "interpolated-settings.xml");
        if (Files.exists(path, new LinkOption[0])) {
            DefaultSettingsBuildingRequest request = new DefaultSettingsBuildingRequest().setUserSettingsFile(path.toAbsolutePath().toFile());
            try {
                Settings isettings = builder.build(request).getEffectiveSettings();
                SettingsUtils.merge(isettings, main, "user-level");
                main = isettings;
            }
            catch (SettingsBuildingException ex) {
                throw new IllegalStateException(ex);
            }
        }
        return main;
    }
}

