/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.javaoperationactivity.operation.deploy;

import io.intino.alexandria.logger.Logger;
import io.intino.consul.javaoperationactivity.box.schemas.Service;
import io.intino.consul.javaoperationactivity.operation.deploy.LibraryResolver;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.sonatype.aether.artifact.Artifact;
import org.sonatype.aether.resolution.DependencyResolutionException;
import org.sonatype.aether.util.artifact.DefaultArtifact;

public class ArtifactResolver {
    private static final String CouldNotFindArtifact = "Could not find artifact";
    private final File localRepository;

    public ArtifactResolver(File localRepository) {
        this.localRepository = localRepository;
    }

    List<Artifact> failOverResolveArtifacts(Service service) throws Exception {
        List<Artifact> artifacts;
        try {
            artifacts = this.resolveArtifacts(service);
        }
        catch (DependencyResolutionException e) {
            String error = this.error(e);
            Logger.error((String)error);
            if (this.resolveFailingDependencyArtifact(this.mavenId(error), service)) {
                throw new Exception("Artifacts couldn't be resolved.\n" + error);
            }
            try {
                artifacts = this.resolveArtifacts(service);
            }
            catch (DependencyResolutionException e2) {
                throw new Exception("Artifacts couldn't be resolved.\n" + error);
            }
        }
        return artifacts;
    }

    private boolean resolveFailingDependencyArtifact(String mavenId, Service service) {
        if (mavenId == null) {
            return false;
        }
        Logger.info((String)("Resolving failed dependency " + mavenId));
        try {
            return this.resolveArtifact(new DefaultArtifact(mavenId), service).isEmpty();
        }
        catch (DependencyResolutionException e) {
            return false;
        }
    }

    private String mavenId(String error) {
        if (!error.contains(CouldNotFindArtifact)) {
            return null;
        }
        String substring = error.substring(error.lastIndexOf(CouldNotFindArtifact));
        substring = substring.replace("Could not find artifact ", "");
        return substring.substring(0, substring.indexOf(" ")).trim();
    }

    private List<Artifact> resolveArtifacts(Service service) throws DependencyResolutionException {
        Logger.info((String)("Resolving artifacts of " + service.identifier()));
        this.deleteMainArtifact(this.localRepository, service);
        DefaultArtifact artifact = new DefaultArtifact(service.artifact().identifier());
        return this.resolveArtifact(artifact, service);
    }

    List<Artifact> resolveArtifact(DefaultArtifact artifact, Service service) throws DependencyResolutionException {
        LibraryResolver resolver = new LibraryResolver(this.localRepository, service.artifact().artifactoryList());
        ArrayList<Artifact> result = new ArrayList<Artifact>(resolver.resolve(artifact, "compile"));
        result.addAll(resolver.resolve(artifact, "runtime"));
        return result;
    }

    private void deleteMainArtifact(File localRepository, Service service) {
        try {
            Service.Artifact artifact = service.artifact();
            File directory = new File(localRepository, artifact.groupId().replace(".", File.separator) + File.separator + artifact.artifactId() + File.separator + artifact.version());
            FileUtils.deleteDirectory(directory);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private String error(DependencyResolutionException e) {
        String stackTrace = ExceptionUtils.getStackTrace(e);
        return Arrays.stream(stackTrace.split("\n")).filter(l -> l.contains(CouldNotFindArtifact) || l.contains("Caused by:")).distinct().collect(Collectors.joining("\n"));
    }
}

