/*
 * Decompiled with CFR 0.152.
 */
package io.intino.consul.javaoperationactivity;

import io.intino.alexandria.logger.Logger;
import io.intino.alexandria.scheduler.AlexandriaScheduler;
import io.intino.consul.framework.Activity;
import io.intino.consul.javaoperationactivity.sentinels.Sentinels;
import io.intino.consul.javaoperationactivity.service.JavaOperationService;
import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.attribute.UserPrincipalLookupService;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class JavaOperationActivity
implements Activity {
    public static final String ID = "java-operation-activity";
    private final Set<String> requiredParameters = new HashSet<String>();
    private Activity.Context context;
    private Activity.Store store;
    private JavaOperationService operationService;
    private AlexandriaScheduler scheduler;

    public JavaOperationActivity() {
        this.requiredParameters.add("applications-directory");
        this.requiredParameters.add("applications-workspace");
        this.requiredParameters.add("logs-directory");
        this.requiredParameters.add("tmp-directory");
        this.requiredParameters.add("deploy-user");
        this.requiredParameters.add("deploy-group");
        this.requiredParameters.add("local-repository");
    }

    public String id() {
        return ID;
    }

    public boolean configure(Activity.Context context, Activity.Store store) {
        this.context = context;
        this.store = store;
        this.operationService = new JavaOperationService(this.id(), context, store);
        this.scheduler = new AlexandriaScheduler(this.id());
        boolean allMatch = this.requiredParameters.stream().allMatch(context.initialConfiguration()::containsKey);
        String user = (String)context.initialConfiguration().get("deploy-user");
        try {
            UserPrincipalLookupService lookupService = FileSystems.getDefault().getUserPrincipalLookupService();
            lookupService.lookupPrincipalByName(user);
        }
        catch (IOException e) {
            Logger.error((String)("Required user is not created: " + e.getMessage()));
            allMatch = false;
        }
        String javaHome = (String)context.initialConfiguration().get("java-home");
        if (javaHome != null && !javaHome.isEmpty()) {
            try {
                if (context.system().operatingSystem().fileSystem().exists(javaHome)) {
                    Logger.error((String)"Required directory of java home");
                    return false;
                }
            }
            catch (Exception e) {
                Logger.error((Throwable)e);
                return false;
            }
        }
        return allMatch;
    }

    public Map<String, String> currentConfiguration() {
        return this.context.initialConfiguration();
    }

    public void onStart() {
        try {
            Sentinels.init(this.id(), this.scheduler, this.context, this.store);
            this.scheduler.startSchedules();
            this.operationService.start();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
    }

    public void onStop() {
        try {
            if (this.scheduler != null) {
                this.scheduler.shutdownSchedules();
            }
            this.operationService.stop();
        }
        catch (Exception e) {
            Logger.error((Throwable)e);
        }
    }
}

